/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing.outbound;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.test.integration.routing.outbound.Component1Exception;
import org.mule.test.integration.routing.outbound.Component2Exception;

public class ChainingRouterNullsHandlingTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/routing/outbound/chaining-router-null-handling-service.xml"}});
    }

    public ChainingRouterNullsHandlingTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testNoComponentFails() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"thePayload", muleContext);
        MuleMessage result = client.send("vm://incomingPass", (MuleMessage)message);
        Assert.assertNull((String)"Shouldn't have any exceptions", (Object)result.getExceptionPayload());
        Assert.assertEquals((Object)"thePayload Received component1 Received component2Pass", (Object)result.getPayloadAsString());
    }

    @Test
    public void testLastComponentFails() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"thePayload", muleContext);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://incomingLastFail", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getExceptionPayload());
        Assert.assertEquals(Component2Exception.class, result.getExceptionPayload().getRootException().getClass());
    }

    @Test
    public void testFirstComponentFails() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"thePayload", muleContext);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://incomingFirstFail", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getExceptionPayload());
        Assert.assertEquals(Component1Exception.class, result.getExceptionPayload().getRootException().getClass());
    }
}

