/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing.outbound;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.Orange;

public class ExpressionSplitterSyncTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/routing/outbound/expression-splitter-sync-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/routing/outbound/expression-splitter-sync-test-flow.xml"});
    }

    public ExpressionSplitterSyncTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testRecipientList() throws Exception {
        FruitBowl fruitBowl = new FruitBowl(new Apple(), new Banana());
        fruitBowl.addFruit((Fruit)new Orange());
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://distributor.queue", (Object)fruitBowl, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof MuleMessageCollection));
        MuleMessageCollection coll = (MuleMessageCollection)result;
        Assert.assertEquals((long)3L, (long)coll.size());
        List results = (List)coll.getPayload();
        Assert.assertTrue((boolean)results.contains("Apple Received in ServiceOne"));
        Assert.assertTrue((boolean)results.contains("Banana Received in ServiceTwo"));
        Assert.assertTrue((boolean)results.contains("Orange Received in ServiceThree"));
    }
}

