/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing.outbound;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class ExpressionSplitterXPathTestCase
extends AbstractServiceAndFlowTestCase {
    private final String MESSAGE = "<Batch xmlns=\"http://acme.com\">\n    <Trade>\n        <Type>CASH</Type>\n        <Amount>40000</Amount>\n        <Currency>USD</Currency>\n        <Date>28102008</Date>\n    </Trade>    \n    <Trade>\n        <Type>CASH</Type>\n        <Amount>2000</Amount>\n        <Currency>GBP</Currency>\n        <Date>28102008</Date>\n    </Trade>    \n</Batch>";
    private final String EXPECTED_MESSAGE_1 = "<Trade xmlns=\"http://acme.com\">\n        <Type>CASH</Type>\n        <Amount>40000</Amount>\n        <Currency>USD</Currency>\n        <Date>28102008</Date>\n        <Received/>\n    </Trade>";
    private final String EXPECTED_MESSAGE_2 = "<Trade xmlns=\"http://acme.com\">\n        <Type>CASH</Type>\n        <Amount>2000</Amount>\n        <Currency>GBP</Currency>\n        <Date>28102008</Date>\n        <Received/>\n    </Trade>";

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/routing/outbound/expression-splitter-xpath-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/routing/outbound/expression-splitter-xpath-test-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW_EL, "org/mule/test/integration/routing/outbound/expression-splitter-xpath-test-flow-el.xml"});
    }

    public ExpressionSplitterXPathTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }

    @Test
    public void testRecipientList() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://distributor.queue", (Object)"<Batch xmlns=\"http://acme.com\">\n    <Trade>\n        <Type>CASH</Type>\n        <Amount>40000</Amount>\n        <Currency>USD</Currency>\n        <Date>28102008</Date>\n    </Trade>    \n    <Trade>\n        <Type>CASH</Type>\n        <Amount>2000</Amount>\n        <Currency>GBP</Currency>\n        <Date>28102008</Date>\n    </Trade>    \n</Batch>", null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof MuleMessageCollection));
        MuleMessageCollection coll = (MuleMessageCollection)result;
        Assert.assertEquals((long)2L, (long)coll.size());
        List results = (List)coll.getPayload();
        Assert.assertTrue((boolean)XMLUnit.compareXML((String)"<Trade xmlns=\"http://acme.com\">\n        <Type>CASH</Type>\n        <Amount>40000</Amount>\n        <Currency>USD</Currency>\n        <Date>28102008</Date>\n        <Received/>\n    </Trade>", (String)results.get(0).toString()).identical());
        Assert.assertTrue((boolean)XMLUnit.compareXML((String)"<Trade xmlns=\"http://acme.com\">\n        <Type>CASH</Type>\n        <Amount>2000</Amount>\n        <Currency>GBP</Currency>\n        <Date>28102008</Date>\n        <Received/>\n    </Trade>", (String)results.get(1).toString()).identical());
    }
}

