/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing.outbound;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.Orange;

public class MulticastAsyncWithTransformersTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/routing/outbound/multicaster-async-with-transformers-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/routing/outbound/multicaster-async-with-transformers-test-flow.xml"});
    }

    public MulticastAsyncWithTransformersTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testSyncMulticast() throws Exception {
        FruitBowl fruitBowl = new FruitBowl(new Apple(), new Banana());
        fruitBowl.addFruit((Fruit)new Orange());
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://distributor.queue", (Object)fruitBowl, null);
        ArrayList<Object> results = new ArrayList<Object>(3);
        MuleMessage result = client.request("vm://collector.queue", 5000L);
        Assert.assertNotNull((Object)result);
        results.add(result.getPayload());
        result = client.request("vm://collector.queue", 3000L);
        Assert.assertNotNull((Object)result);
        results.add(result.getPayload());
        result = client.request("vm://collector.queue", 3000L);
        Assert.assertNotNull((Object)result);
        results.add(result.getPayload());
        Assert.assertTrue((boolean)results.contains("Apple Received"));
        Assert.assertTrue((boolean)results.contains("Banana Received"));
        Assert.assertTrue((boolean)results.contains("Orange Received"));
    }
}

