/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.schedule;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.test.integration.schedule.MockScheduler;
import org.mule.util.Predicate;

public class RunningScheduleTestCase
extends FunctionalTestCase {
    public static final String SCHEDULER_NAME = "testScheduler";

    protected String getConfigFile() {
        return "org/mule/test/integration/schedule/scheduler-config.xml";
    }

    @Test
    public void test() throws Exception {
        Thread.sleep(2000L);
        MockScheduler scheduler = this.findScheduler(SCHEDULER_NAME);
        Assert.assertTrue((scheduler.getCount() > 0 ? 1 : 0) != 0);
        this.stopSchedulers();
        Thread.sleep(2000L);
        int count = scheduler.getCount();
        Thread.sleep(2000L);
        Assert.assertEquals((long)count, (long)scheduler.getCount());
        scheduler.schedule();
        Thread.sleep(2000L);
        Assert.assertEquals((long)(count + 1), (long)scheduler.getCount());
    }

    private void stopSchedulers() throws MuleException {
        this.findScheduler(SCHEDULER_NAME).stop();
    }

    private MockScheduler findScheduler(String schedulerName) {
        return (MockScheduler)muleContext.getRegistry().lookupScheduler((Predicate)new NamePredicate(schedulerName)).iterator().next();
    }

    private class NamePredicate
    implements Predicate<String> {
        private String name;

        private NamePredicate(String name) {
            this.name = name;
        }

        public boolean evaluate(String s) {
            return s.equalsIgnoreCase(this.name);
        }
    }
}

