/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.spring.events.async;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.test.integration.spring.events.Order;
import org.mule.test.integration.spring.events.OrderManagerBean;

public class SpringEventsJmsAsyncExampleTestCase
extends FunctionalTestCase {
    private final AtomicInteger eventCount = new AtomicInteger(0);

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.eventCount.set(0);
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/spring/events/async/mule-events-example-async-app-context.xml";
    }

    @Test
    public void testReceivingASubscriptionEvent() throws Exception {
        OrderManagerBean subscriptionBean = (OrderManagerBean)muleContext.getRegistry().lookupObject("orderManagerBean");
        Assert.assertNotNull((Object)subscriptionBean);
        EventCallback callback = new EventCallback(){

            public void eventReceived(MuleEventContext context, Object o) throws Exception {
                SpringEventsJmsAsyncExampleTestCase.this.eventCount.incrementAndGet();
            }
        };
        subscriptionBean.setEventCallback(callback);
        LocalMuleClient client = muleContext.getClient();
        Order order = new Order("Sausage and Mash");
        client.send("jms://orders.queue", (Object)order, null);
        Thread.sleep(1000L);
        Assert.assertTrue((this.eventCount.get() == 1 ? 1 : 0) != 0);
        MuleMessage result = client.request("jms://processed.queue", 10000L);
        Assert.assertEquals((long)1L, (long)this.eventCount.intValue());
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"Order 'Sausage and Mash' Processed", (Object)result.getPayloadAsString());
    }
}

