/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.streaming;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.file.FileExists;
import org.mule.util.FileUtils;

public class FileToTcpStreamingTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/streaming/file-to-tcp-streaming-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/streaming/file-to-tcp-streaming-flow.xml"});
    }

    public FileToTcpStreamingTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected void doTearDown() throws Exception {
        FileUtils.deleteDirectory((File)FileUtils.newFile((String)(muleContext.getConfiguration().getWorkingDirectory() + "/test-data")));
    }

    @Test
    public void testStreamingFromFileToTcp() throws Exception {
        String text = "\nblah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah \nblah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah \nblah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah \nblah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah\n\n";
        String basepath = muleContext.getConfiguration().getWorkingDirectory() + "/test-data";
        FileUtils.stringToFile((String)(basepath + "/in/foo.txt"), (String)text);
        File file = FileUtils.newFile((String)basepath, (String)"out/foo.txt.processed");
        PollingProber pollingProber = new PollingProber(5000L, 10L);
        pollingProber.check((Probe)new FileExists(file));
        String result = FileUtils.readFileToString((File)file, (String)"UTF8");
        Assert.assertEquals((Object)text, (Object)result);
    }
}

