/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transaction;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.concurrent.Latch;

public class TransactionalElementLifecycleTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/transaction/transactional-lifecycle-config.xml";
    }

    @Test
    public void testInitializeIsCalledInInnerExceptionStrategy() throws Exception {
        final Latch endDlqFlowLatch = new Latch();
        LocalMuleClient client = muleContext.getClient();
        FunctionalTestComponent functionalTestComponent = this.getFunctionalTestComponent("dlq-out");
        functionalTestComponent.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                endDlqFlowLatch.release();
            }
        });
        client.send("vm://in", (Object)"message", null, 5000L);
        if (!endDlqFlowLatch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"message wasn't received by dlq flow");
        }
    }
}

