/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transaction.xa;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.integration.transaction.xa.FailureGeneratorMessageProcessor;

public class TransactionScenarios {
    private final InboundMessagesGenerator inboundMessagesGenerator;
    private final OutboundMessagesCounter outboundMessagesVerifier;
    private int verificationTimeout = 1000;

    public TransactionScenarios(InboundMessagesGenerator inboundMessagesGenerator, OutboundMessagesCounter outboundMessagesVerifier) {
        this.inboundMessagesGenerator = inboundMessagesGenerator;
        this.outboundMessagesVerifier = outboundMessagesVerifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoFailureDuringFlowExecution() {
        try {
            FailureGeneratorMessageProcessor.noFailure();
            this.testFlow(false);
        }
        finally {
            this.outboundMessagesVerifier.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIntermittentFailureDuringFlowExecution() {
        try {
            FailureGeneratorMessageProcessor.generateIntermitentFailure();
            this.testFlow(false);
        }
        finally {
            this.outboundMessagesVerifier.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAlwaysFailureDuringFlowException() {
        try {
            FailureGeneratorMessageProcessor.allFailure();
            this.testFlow(true);
        }
        finally {
            this.outboundMessagesVerifier.close();
        }
    }

    private void testFlow(boolean noMessageExpected) {
        try {
            final Integer numberOfMessagesCreated = this.inboundMessagesGenerator.generateInboundMessages();
            if (noMessageExpected) {
                Thread.sleep(this.verificationTimeout);
                Assert.assertThat((Object)this.outboundMessagesVerifier.numberOfMessagesThatArrived(), (Matcher)Is.is((Object)0));
            } else {
                new PollingProber(10000L, 100L).check(new Probe(){

                    public boolean isSatisfied() {
                        try {
                            return TransactionScenarios.this.outboundMessagesVerifier.numberOfMessagesThatArrived() == numberOfMessagesCreated.intValue();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public String describeFailure() {
                        try {
                            return String.format("Not all the messages arrived. Only %d of %s arrived", TransactionScenarios.this.outboundMessagesVerifier.numberOfMessagesThatArrived(), numberOfMessagesCreated);
                        }
                        catch (Exception e) {
                            return String.format("Not all messages arrived.", new Object[0]);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TransactionScenarios setVerificationTimeout(int verificationTimeout) {
        this.verificationTimeout = verificationTimeout;
        return this;
    }

    public static interface OutboundMessagesCounter {
        public int numberOfMessagesThatArrived() throws Exception;

        public void close();
    }

    public static interface InboundMessagesGenerator {
        public static final int NUMBER_OF_MESSAGES = 6;

        public Integer generateInboundMessages() throws Exception;
    }
}

