/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transaction.xa;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.util.MuleDerbyTestUtils;
import org.mule.test.integration.transaction.extras.Book;
import org.mule.transport.jdbc.JdbcUtils;

public class XATransactionsWithSpringDAO
extends FunctionalTestCase {
    private static final int RECEIVE_TIMEOUT = 10000;
    private static String connectionString;

    protected String getConfigFile() {
        return "org/mule/test/integration/transaction/xatransactions-with-spring-dao-config.xml";
    }

    @BeforeClass
    public static void startDatabase() throws Exception {
        String dbName = MuleDerbyTestUtils.loadDatabaseName((String)"derby.properties", (String)"database.name");
        MuleDerbyTestUtils.defaultDerbyCleanAndInit((String)"derby.properties", (String)"database.name");
        connectionString = "jdbc:derby:" + dbName;
    }

    @AfterClass
    public static void stopDatabase() throws SQLException {
        MuleDerbyTestUtils.stopDatabase();
    }

    @Before
    public void emptyTable() throws Exception {
        try {
            this.execSqlUpdate("DELETE FROM BOOK");
        }
        catch (Exception e) {
            this.execSqlUpdate("CREATE TABLE BOOK(ID INTEGER NOT NULL PRIMARY KEY,TITLE VARCHAR(255),AUTHOR VARCHAR(255))");
        }
    }

    protected Connection getConnection() throws Exception {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        return DriverManager.getConnection(connectionString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List execSqlQuery(String sql) throws Exception {
        Connection con = null;
        try {
            con = this.getConnection();
            List list = (List)new QueryRunner().query(con, sql, (ResultSetHandler)new ArrayListHandler());
            return list;
        }
        finally {
            JdbcUtils.close((Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execSqlUpdate(String sql) throws Exception {
        Connection con = null;
        try {
            con = this.getConnection();
            int n = new QueryRunner().update(con, sql);
            return n;
        }
        finally {
            JdbcUtils.close((Connection)con);
        }
    }

    @Test
    public void testXATransactionUsingSpringDaoNoRollback() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        Book book = new Book(1, "testBook", "testAuthor");
        client.sendNoReceive("jms://my.queue", (Object)book, null);
        MuleMessage result = client.request("vm://output", 10000L);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertTrue((boolean)((Boolean)result.getPayload()));
        int res = this.execSqlUpdate("UPDATE BOOK SET TITLE = 'My Test' WHERE TITLE='testBook'");
        if (res < 0) {
            Assert.fail();
        }
    }

    @Test
    public void testXATransactionUsingSpringDaoWithRollback() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        Book book = new Book(1, "testBook", "testAuthor");
        client.sendNoReceive("jms://my.queue", (Object)book, null);
        MuleMessage result = client.request("vm://output", 10000L);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertTrue((boolean)((Boolean)result.getPayload()));
        int res = this.execSqlUpdate("UPDATE BOOK SET TITLE = 'My Test' WHERE TITLE='testBook'");
        if (res < 0) {
            Assert.fail();
        }
        client.sendNoReceive("jms://my.queue", (Object)book, null);
        result = client.request("vm://output", 5000L);
        Assert.assertNull((Object)result);
    }
}

