/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transformer.response;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class ResponseTransformerScenariosTestCase
extends FunctionalTestCase {
    private static String VM_INBOUND = " inbound";
    private static String VM_OUTBOUND = " outbound";
    private static String VM_RESPONSE = " response";
    private static String VM_OUT_IN_RESP = VM_OUTBOUND + VM_INBOUND + VM_RESPONSE;
    private static String CUSTOM_RESPONSE = " customResponse";
    @ClassRule
    public static DynamicPort httpPort1 = new DynamicPort("port1");
    @ClassRule
    public static DynamicPort httpPort2 = new DynamicPort("port2");
    @ClassRule
    public static DynamicPort httpPort3 = new DynamicPort("port3");

    public ResponseTransformerScenariosTestCase() {
        this.setDisposeContextPerClass(true);
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/transformer/response/response-transformer-scenarios.xml";
    }

    @Test
    public void testVmSync() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://sync", (Object)"request", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)("request" + VM_OUT_IN_RESP), (Object)message.getPayloadAsString());
    }

    @Test
    public void testVmSyncResponseTransformer() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("MULE_DISABLE_TRANSPORT_TRANSFORMER", "true");
        MuleMessage message = client.send("vm://syncResponseTransformer", (Object)"request", props);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)("request" + CUSTOM_RESPONSE), (Object)message.getPayloadAsString());
    }

    @Test
    public void testHttpSync() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("http://localhost:" + httpPort2.getNumber(), (Object)"request", null);
        Assert.assertNotNull((Object)message);
        String server = (String)message.getInboundProperty("Server");
        Assert.assertTrue((boolean)server.startsWith("Mule"));
        String dateStr = (String)message.getInboundProperty("Date");
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss zzz", Locale.US);
        Date msgDate = format.parse(dateStr);
        Assert.assertTrue((boolean)new Date().after(msgDate));
        Assert.assertEquals((Object)"request", (Object)message.getPayloadAsString());
    }

    @Test
    public void testHttpSyncResponseTransformer() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("http://localhost:" + httpPort3.getNumber(), (Object)"request", null);
        Assert.assertNotNull((Object)message);
        String server = (String)message.getInboundProperty("Server");
        Assert.assertTrue((boolean)server.startsWith("Mule"));
        String dateStr = (String)message.getInboundProperty("Date");
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss zzz", Locale.US);
        Date msgDate = format.parse(dateStr);
        Assert.assertTrue((boolean)new Date().after(msgDate));
        Assert.assertEquals((Object)("request" + CUSTOM_RESPONSE), (Object)message.getPayloadAsString());
    }

    @Test
    public void testVmSyncOutboundEndpointResponseTransformer() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://syncOutboundEndpointResponseTransformer", (Object)"request", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)("request" + VM_OUTBOUND + VM_INBOUND + VM_OUT_IN_RESP + CUSTOM_RESPONSE + VM_RESPONSE), (Object)message.getPayloadAsString());
    }

    @Test
    public void testJmsRemoteSync() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://jmsSync", (Object)"request", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)("request" + VM_OUT_IN_RESP), (Object)message.getPayloadAsString());
    }

    @Test
    public void testJmsSyncOutboundEndpointResponseTransformer() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://jmsSyncOutboundEndpointResponseTransformer", (Object)"request", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)("request" + VM_OUTBOUND + VM_INBOUND + CUSTOM_RESPONSE + VM_RESPONSE), (Object)message.getPayloadAsString());
    }

    @Test
    public void testChainedRouterOutboundEndpointResponseTransformer() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://chainedRouterOutboundEndpointResponseTransformer", (Object)"request", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)("request" + VM_OUTBOUND + VM_INBOUND + VM_OUT_IN_RESP + VM_OUT_IN_RESP + CUSTOM_RESPONSE + CUSTOM_RESPONSE + VM_RESPONSE), (Object)message.getPayloadAsString());
    }

    @Test
    public void testNestedRouterOutboundEndpointResponseTransformer() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://nestedRouterOutboundEndpointResponseTransformer", (Object)"request", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)("request" + VM_OUTBOUND + VM_INBOUND + VM_OUT_IN_RESP + CUSTOM_RESPONSE + CUSTOM_RESPONSE + VM_RESPONSE), (Object)message.getPayloadAsString());
    }
}

