/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transport.cxf;

import java.util.List;
import java.util.Map;
import org.apache.cxf.endpoint.Client;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.endpoint.AbstractEndpointBuilder;
import org.mule.module.cxf.CxfOutboundMessageProcessor;
import org.mule.module.cxf.config.FlowConfiguringMessageProcessor;
import org.mule.tck.junit4.FunctionalTestCase;

public class CxfClientPassivateTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/transport/cxf/cxf-memoryleak-config.xml";
    }

    @Test
    public void testPassivateCleansClientRequestAndResponseContext() throws Exception {
        LocalMuleClient muleClient = muleContext.getClient();
        muleClient.send("vm://in", (Object)"Test Message", null);
        MuleMessage message = muleClient.request("vm://out", 5000L);
        Assert.assertNotNull((Object)message);
        CxfOutboundMessageProcessor processor = this.getOutboundMessageProcessor();
        Client client = processor.getClient();
        Map requestContext = client.getRequestContext();
        Assert.assertTrue((String)"Request context should be empty", (boolean)requestContext.isEmpty());
        Map responseContext = client.getResponseContext();
        Assert.assertTrue((String)"Response context should be empty", (boolean)responseContext.isEmpty());
    }

    private CxfOutboundMessageProcessor getOutboundMessageProcessor() {
        AbstractEndpointBuilder epbuilder = (AbstractEndpointBuilder)muleContext.getRegistry().lookupEndpointBuilder("clientEndpoint");
        List mps = epbuilder.getMessageProcessors();
        return (CxfOutboundMessageProcessor)((FlowConfiguringMessageProcessor)mps.get(0)).getWrappedMessageProcessor();
    }
}

