/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transport.cxf;

import java.util.Arrays;
import java.util.Collection;
import org.custommonkey.xmlunit.XMLAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class CxfEnvelopePayloadWithWsdlTestCase
extends AbstractServiceAndFlowTestCase {
    private static final String msg = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:emop=\"http://www.wcs.com/2010/07/14/emop\">  <soapenv:Header>\n    <header UserName=\"nothing\" Password=\"important\"/>\n  </soapenv:Header>\n  <soapenv:Body>\n    <emop:ScratchcardValidateAndPayRequestBody>\n       <ScratchcardNumber>1</ScratchcardNumber>\n       <VirnNumber>2</VirnNumber>\n    </emop:ScratchcardValidateAndPayRequestBody>\n  </soapenv:Body>\n</soapenv:Envelope>";

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/transport/cxf/scratchcard-service-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/transport/cxf/scratchcard-service-config-flow.xml"});
    }

    public CxfEnvelopePayloadWithWsdlTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testEnvelopePayloadIsProcessedWhenMessageAndWsdlContainsHeaders() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:28182/ScratchCardServiceV1", (Object)msg, null);
        Assert.assertNotNull((String)"The result shouln't have been null", (Object)result);
        String payloadAsString = result.getPayloadAsString();
        XMLAssert.assertXMLEqual((String)msg, (String)payloadAsString);
    }
}

