/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transport.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.EndpointMessageNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;

public class FileAppendConnectorTestCase
extends AbstractServiceAndFlowTestCase
implements EndpointMessageNotificationListener<EndpointMessageNotification> {
    protected static final String OUTPUT_DIR = "myout";
    protected static final String OUTPUT_FILE = "out.txt";
    protected CountDownLatch fileReceiveLatch = new CountDownLatch(2);

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/providers/file/mule-fileappend-connector-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/providers/file/mule-fileappend-connector-config-flow.xml"});
    }

    public FileAppendConnectorTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        muleContext.registerListener((ServerNotificationListener)this);
    }

    protected void doTearDown() throws Exception {
        File outputDir = FileUtils.newFile((String)OUTPUT_DIR);
        FileUtils.deleteTree((File)outputDir);
        super.doTearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasic() throws Exception {
        FileInputStream myFileStream = null;
        try {
            File myDir = FileUtils.newFile((String)OUTPUT_DIR);
            File myFile = FileUtils.newFile((File)myDir, (String)OUTPUT_FILE);
            Assert.assertFalse((boolean)myFile.exists());
            LocalMuleClient client = muleContext.getClient();
            client.send("vm://fileappend", (Object)"Hello1", null);
            client.send("vm://fileappend", (Object)"Hello2", null);
            Assert.assertTrue((boolean)this.fileReceiveLatch.await(30L, TimeUnit.SECONDS));
            myFileStream = new FileInputStream(myFile);
            Assert.assertEquals((Object)"Hello1Hello2", (Object)IOUtils.toString((InputStream)myFileStream));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(myFileStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)myFileStream);
    }

    public void onNotification(EndpointMessageNotification notification) {
        if (notification.getEndpoint().contains(OUTPUT_DIR)) {
            this.fileReceiveLatch.countDown();
        }
    }
}

