/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transport.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleContext;
import org.mule.api.MuleEventContext;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.functional.FunctionalTestNotification;
import org.mule.tck.functional.FunctionalTestNotificationListener;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.transport.PollingController;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;

public class FileFunctionalTestCase
extends AbstractServiceAndFlowTestCase
implements FunctionalTestNotificationListener {
    @ClassRule
    public static SystemProperty filePollOnlyOnPrimaryNode = new SystemProperty("mule.transport.file.singlepollinstance", "true");
    private Object receivedData = null;
    private boolean shouldPoll;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/providers/file/file-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/providers/file/file-config-flow.xml"});
    }

    public FileFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        muleContext.registerListener((ServerNotificationListener)this);
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        muleContext.unregisterListener((ServerNotificationListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRelative() throws IOException, InterruptedException {
        byte[] data = new byte[100000];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(Math.random() * 128.0);
        }
        File f = FileUtils.newFile((String)"./test/testfile.temp");
        f.createNewFile();
        FileOutputStream fos = new FileOutputStream(f);
        IOUtils.write((byte[])data, (OutputStream)fos);
        IOUtils.closeQuietly((OutputStream)fos);
        this.shouldPoll = false;
        ((DefaultMuleContext)muleContext).setPollingController(new PollingController(){

            public boolean isPrimaryPollingInstance() {
                return FileFunctionalTestCase.this.shouldPoll;
            }
        });
        f.renameTo(FileUtils.newFile((String)f.getPath().replaceAll(".temp", ".data")));
        Thread.sleep(5000L);
        FileFunctionalTestCase fileFunctionalTestCase = this;
        synchronized (fileFunctionalTestCase) {
            Assert.assertNull((Object)this.receivedData);
        }
        this.shouldPoll = true;
        Thread.sleep(5000L);
        fileFunctionalTestCase = this;
        synchronized (fileFunctionalTestCase) {
            Assert.assertNotNull((Object)this.receivedData);
            Assert.assertTrue((boolean)(this.receivedData instanceof byte[]));
            byte[] receivedBytes = (byte[])this.receivedData;
            Assert.assertEquals((long)data.length, (long)receivedBytes.length);
            Assert.assertTrue((boolean)Arrays.equals(data, receivedBytes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotification(ServerNotification notification) {
        FileFunctionalTestCase fileFunctionalTestCase = this;
        synchronized (fileFunctionalTestCase) {
            this.logger.debug((Object)("received notification: " + notification));
            this.receivedData = ((FunctionalTestNotification)notification).getReplyMessage();
        }
    }

    public static class FileTestComponent
    extends FunctionalTestComponent {
        public Object onCall(MuleEventContext context) throws Exception {
            super.setReturnData(context.getMessage().getPayload());
            return super.onCall(context);
        }
    }
}

