/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transport.file;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.EndpointMessageNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.util.FileUtils;

public class OutputPatternFromEndpointTestCase
extends AbstractServiceAndFlowTestCase
implements EndpointMessageNotificationListener<EndpointMessageNotification> {
    protected CountDownLatch fileReceiveLatch;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/providers/file/mule-file-output-pattern-from-endpoint-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/providers/file/mule-file-output-pattern-from-endpoint-flow.xml"});
    }

    public OutputPatternFromEndpointTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        muleContext.registerListener((ServerNotificationListener)this);
        this.fileReceiveLatch = new CountDownLatch(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasic() throws Exception {
        File myDir2;
        String myFirstDirName = "FirstWrite";
        String mySecondDirName = "SecondWrite";
        String myFileName1 = "export.txt";
        String myFileName2 = "export.txt.OK";
        final File myDir = FileUtils.newFile((String)myFirstDirName);
        if (myDir.isDirectory()) {
            File[] files = myDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Assert.assertTrue((boolean)files[i].delete());
            }
            Assert.assertTrue((boolean)myDir.delete());
        }
        if ((myDir2 = FileUtils.newFile((String)mySecondDirName)).isDirectory()) {
            File[] files = myDir2.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Assert.assertTrue((boolean)files[i].delete());
            }
            Assert.assertTrue((boolean)myDir2.delete());
        }
        try {
            Assert.assertFalse((boolean)FileUtils.newFile((File)myDir, (String)"export.txt").exists());
            Assert.assertFalse((boolean)FileUtils.newFile((File)myDir2, (String)"export.txt.OK").exists());
            LocalMuleClient client = muleContext.getClient();
            client.send("vm://filesend", (Object)"Hello", null);
            Assert.assertTrue((boolean)this.fileReceiveLatch.await(30L, TimeUnit.SECONDS));
            PollingProber prober = new PollingProber(2000L, 50L);
            prober.check(new Probe(){

                public boolean isSatisfied() {
                    return FileUtils.newFile((File)myDir, (String)"export.txt").exists() && FileUtils.newFile((File)myDir2, (String)"export.txt.OK").exists();
                }

                public String describeFailure() {
                    return "Failed to create the expected files";
                }
            });
        }
        catch (AssertionFailedError e1) {
            e1.printStackTrace();
        }
        finally {
            FileUtils.newFile((File)myDir, (String)"export.txt").delete();
            FileUtils.newFile((File)myDir2, (String)"export.txt.OK").delete();
            myDir.delete();
            myDir2.delete();
        }
    }

    public void onNotification(EndpointMessageNotification notification) {
        if (notification.getEndpoint().contains("SecondWrite")) {
            this.fileReceiveLatch.countDown();
        } else if (notification.getEndpoint().contains("FirstWrite")) {
            this.fileReceiveLatch.countDown();
        }
    }
}

