/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transport.jdbc;

import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.component.Component;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.context.notification.TransactionNotificationListener;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.object.ObjectFactory;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.MatchableMessageProcessor;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.source.CompositeMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transaction.TransactionFactory;
import org.mule.component.DefaultJavaComponent;
import org.mule.context.notification.TransactionNotification;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.model.seda.SedaService;
import org.mule.object.PrototypeObjectFactory;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.service.AbstractService;
import org.mule.tck.functional.EventCallback;
import org.mule.test.integration.transport.jdbc.AbstractJdbcFunctionalTestCase;
import org.mule.transaction.MuleTransactionConfig;

public abstract class AbstractJdbcTransactionalFunctionalTestCase
extends AbstractJdbcFunctionalTestCase
implements TransactionNotificationListener<TransactionNotification> {
    private Transaction currentTx;
    protected boolean rollbacked = false;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        muleContext.registerListener((ServerNotificationListener)this);
        this.currentTx = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReceiveAndSendWithException() throws Exception {
        final AtomicBoolean called = new AtomicBoolean(false);
        EventCallback callback = new EventCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                try {
                    called.set(true);
                    AbstractJdbcTransactionalFunctionalTestCase.this.currentTx = context.getCurrentTransaction();
                    Assert.assertNotNull((Object)AbstractJdbcTransactionalFunctionalTestCase.this.currentTx);
                    Assert.assertTrue((boolean)AbstractJdbcTransactionalFunctionalTestCase.this.currentTx.isBegun());
                    AbstractJdbcTransactionalFunctionalTestCase.this.currentTx.setRollbackOnly();
                }
                finally {
                    AtomicBoolean atomicBoolean = called;
                    synchronized (atomicBoolean) {
                        called.notifyAll();
                    }
                }
            }
        };
        this.initialiseService((byte)1, callback);
        muleContext.start();
        this.execSqlUpdate("INSERT INTO TEST(TYPE, DATA, ACK, RESULT) VALUES (1, 'Test Message', NULL, NULL)");
        AtomicBoolean atomicBoolean = called;
        synchronized (atomicBoolean) {
            called.wait(20000L);
        }
        Assert.assertTrue((boolean)called.get());
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)this.rollbacked);
        Object[] obj = this.execSqlQuery("SELECT COUNT(*) FROM TEST WHERE TYPE = 2");
        Assert.assertNotNull((Object)obj);
        Assert.assertEquals((long)1L, (long)obj.length);
        Assert.assertEquals((Object)new Integer(0), (Object)obj[0]);
        obj = this.execSqlQuery("SELECT ACK FROM TEST WHERE TYPE = 1");
        Assert.assertNotNull((Object)obj);
        Assert.assertEquals((long)1L, (long)obj.length);
        Assert.assertNull((Object)obj[0]);
    }

    public Service initialiseService(byte txBeginAction, EventCallback callback) throws Exception {
        SedaService service = new SedaService(muleContext);
        ((AbstractService)service).setExceptionListener((MessagingExceptionHandler)new DefaultMessagingExceptionStrategy(muleContext));
        service.setName("testComponent");
        service.setComponent((Component)new DefaultJavaComponent((ObjectFactory)new PrototypeObjectFactory(AbstractJdbcFunctionalTestCase.JdbcFunctionalTestComponent.class)));
        TransactionFactory tf = this.getTransactionFactory();
        MuleTransactionConfig txConfig = new MuleTransactionConfig(txBeginAction);
        txConfig.setFactory(tf);
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(this.getInDest(), muleContext);
        endpointBuilder.setName("testIn");
        endpointBuilder.setConnector(this.connector);
        endpointBuilder.setTransactionConfig((TransactionConfig)txConfig);
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint((EndpointBuilder)endpointBuilder);
        EndpointURIEndpointBuilder endpointBuilder2 = new EndpointURIEndpointBuilder(this.getOutDest(), muleContext);
        endpointBuilder2.setName("testOut");
        endpointBuilder2.setConnector(this.connector);
        OutboundEndpoint outProvider = muleContext.getEndpointFactory().getOutboundEndpoint((EndpointBuilder)endpointBuilder2);
        service.setOutboundMessageProcessor((MessageProcessor)new DefaultOutboundRouterCollection());
        OutboundPassThroughRouter router = new OutboundPassThroughRouter();
        router.addRoute((MessageProcessor)outProvider);
        ((OutboundRouterCollection)service.getOutboundMessageProcessor()).addRoute((MatchableMessageProcessor)router);
        ((CompositeMessageSource)service.getMessageSource()).addSource((MessageSource)endpoint);
        service.setModel(this.model);
        muleContext.getRegistry().registerService((Service)service);
        return service;
    }

    public void onNotification(TransactionNotification notification) {
        if (notification.getAction() == 1203) {
            this.rollbacked = true;
        }
    }

    protected abstract TransactionFactory getTransactionFactory();
}

