/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.util;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ObjectNameHelperTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testEndpointAutomaticNames() throws Exception {
        InboundEndpoint ep = muleContext.getEndpointFactory().getInboundEndpoint("test://cn=foo,name=queue");
        muleContext.getRegistry().registerEndpoint((ImmutableEndpoint)ep);
        Assert.assertEquals((Object)"endpoint.test.cn.foo.name.queue", (Object)ep.getName());
        ep = muleContext.getEndpointFactory().getInboundEndpoint("test://cn=foo,name=queue");
        Assert.assertEquals((Object)"endpoint.test.cn.foo.name.queue.1", (Object)ep.getName());
        ep = muleContext.getEndpointFactory().getInboundEndpoint("vm://my.queue");
        Assert.assertEquals((Object)"endpoint.vm.my.queue", (Object)ep.getName());
        ep = muleContext.getEndpointFactory().getInboundEndpoint("pop3://ross:secret@mail.mycompany.com?subject=foo");
        Assert.assertEquals((Object)"endpoint.pop3.ross.mycompany.com", (Object)ep.getName());
    }

    @Test
    public void testEndpointNames() throws Exception {
        InboundEndpoint ep = muleContext.getEndpointFactory().getInboundEndpoint("test://cn=foo,name=queue?endpointName=foo");
        muleContext.getRegistry().registerEndpoint((ImmutableEndpoint)ep);
        Assert.assertEquals((Object)"endpoint.test.cn.foo.name.queue", (Object)ep.getName());
        ep = muleContext.getEndpointFactory().getInboundEndpoint("test://cn=foo,name=queue?endpointName=this_is@aWierd-Name:x");
        Assert.assertEquals((Object)"this.is.aWierd.Name.x", (Object)ep.getName());
        muleContext.getRegistry().registerEndpoint((ImmutableEndpoint)ep);
        ep = muleContext.getEndpointFactory().getInboundEndpoint("test://cn=foo,name=queue?endpointName=this_is@aWierd-Name:x");
        Assert.assertEquals((Object)"this.is.aWierd.Name.x", (Object)ep.getName());
        ep = muleContext.getEndpointFactory().getInboundEndpoint("test://cn=foo,name=queue?endpointName=this____is+another=@Wierd----Name:x:::");
        Assert.assertEquals((Object)"this.is.another.Wierd.Name.x", (Object)ep.getName());
    }

    @Test
    public void testTestEndpoint() throws Exception {
        InboundEndpoint ep = muleContext.getEndpointFactory().getInboundEndpoint("test://exception.listener");
        muleContext.getRegistry().registerEndpoint((ImmutableEndpoint)ep);
        Assert.assertEquals((Object)"endpoint.test.exception.listener", (Object)ep.getName());
    }
}

