/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.properties;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class PropertiesTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/properties/properties-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/properties/properties-config-flow.xml"});
    }

    public PropertiesTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testProperties() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage msg1 = this.createOutboundMessage();
        MuleMessage response = client.send("vm://in", msg1);
        Assert.assertEquals((Object)response.getPayloadAsString(), (Object)"OK(success)");
        Assert.assertNull((Object)response.getInboundProperty("outbound1"));
        Assert.assertNull((Object)response.getInboundProperty("outbound2"));
        Assert.assertNull((Object)response.getOutboundProperty("outbound1"));
        Assert.assertNull((Object)response.getOutboundProperty("outbound2"));
        Assert.assertEquals((Object)"ja", (Object)response.getInvocationProperty("invocation1"));
        Assert.assertEquals((Object)"nein", (Object)response.getInvocationProperty("invocation2"));
        Assert.assertEquals((Object)"123", (Object)response.getInboundProperty("outbound3"));
        Assert.assertEquals((Object)"456", (Object)response.getInboundProperty("outbound4"));
        Assert.assertNull((Object)response.getInvocationProperty("invocation3"));
        Assert.assertNull((Object)response.getInvocationProperty("invocation4"));
        MuleMessage msg2 = this.createOutboundMessage();
        client.dispatch("vm://inQueue", msg2);
        response = client.request("vm://outQueue", 5000L);
        Assert.assertEquals((Object)response.getPayloadAsString(), (Object)"OK");
        Assert.assertEquals((Object)"yes", (Object)response.getInboundProperty("outbound1"));
        Assert.assertEquals((Object)"no", (Object)response.getInboundProperty("outbound2"));
        Assert.assertNull((Object)response.getOutboundProperty("outbound1"));
        Assert.assertNull((Object)response.getOutboundProperty("outbound2"));
        Assert.assertNull((Object)response.getInvocationProperty("invocation1"));
        Assert.assertNull((Object)response.getInvocationProperty("invocation2"));
    }

    private MuleMessage createOutboundMessage() {
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"OK", muleContext);
        msg.setOutboundProperty("outbound1", (Object)"yes");
        msg.setOutboundProperty("outbound2", (Object)"no");
        msg.setInvocationProperty("invocation1", (Object)"ja");
        msg.setInvocationProperty("invocation2", (Object)"nein");
        return msg;
    }

    public static class Component {
        public MuleMessage process(Object payload) {
            DefaultMuleMessage msg = new DefaultMuleMessage((Object)(payload + "(success)"), muleContext);
            msg.setOutboundProperty("outbound3", (Object)"123");
            msg.setOutboundProperty("outbound4", (Object)"456");
            msg.setInvocationProperty("invocation3", (Object)"UVW");
            msg.setInvocationProperty("invocation4", (Object)"XYZ");
            return msg;
        }
    }
}

