/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.RoutingNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.RoutingNotification;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.FunctionalTestComponent;

public class CollectionAggregatorRouterTimeoutTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "collection-aggregator-router-timeout-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "collection-aggregator-router-timeout-test-flow.xml"});
    }

    public CollectionAggregatorRouterTimeoutTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testNoFailOnTimeout() throws Exception {
        final AtomicInteger correlationTimeoutCount = new AtomicInteger(0);
        muleContext.registerListener((ServerNotificationListener)new RoutingNotificationListener<RoutingNotification>(){

            public void onNotification(RoutingNotification notification) {
                if (notification.getAction() == 1303) {
                    correlationTimeoutCount.incrementAndGet();
                }
            }
        });
        FunctionalTestComponent vortex = (FunctionalTestComponent)this.getComponent("vortex");
        FunctionalTestComponent aggregator = (FunctionalTestComponent)this.getComponent("aggregator");
        LocalMuleClient client = muleContext.getClient();
        List<String> list = Arrays.asList("first", "second");
        client.dispatch("vm://splitter", list, null);
        Thread.sleep(5000L);
        Assert.assertEquals((String)"Correlation timeout should not have happened.", (long)0L, (long)correlationTimeoutCount.intValue());
        Assert.assertEquals((String)"Vortex received wrong number of messages.", (long)1L, (long)vortex.getReceivedMessagesCount());
        Assert.assertEquals((String)"Wrong message received", (Object)"second", (Object)vortex.getLastReceivedMessage());
        Assert.assertEquals((String)"Aggregator received wrong number of messages.", (long)1L, (long)aggregator.getReceivedMessagesCount());
        Assert.assertEquals((String)"Wrong message received", Arrays.asList("first"), (Object)aggregator.getLastReceivedMessage());
        Thread.sleep(9000L);
        Assert.assertEquals((String)"Other messages never received by aggregator.", (long)1L, (long)aggregator.getReceivedMessagesCount());
        Assert.assertNotNull((Object)client.request("vm://out?connector=queue", 10000L));
    }
}

