/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.construct.Flow;
import org.mule.test.routing.CustomRouteResolver;
import org.mule.test.routing.DynamicRouterTestCase;

public class DynamicAllTestCase
extends DynamicRouterTestCase {
    private static final String DYNAMIC_ALL = "dynamicAll";

    protected String getConfigFile() {
        return "org/mule/test/integration/routing/dynamic-all-config.xml";
    }

    @Override
    public String getFlowName() {
        return DYNAMIC_ALL;
    }

    @Test
    public void withRoutes() throws Exception {
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("a"));
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("b"));
        this.runFlowAndAssertResponse(this.getTestFlow(DYNAMIC_ALL), "a", "b");
    }

    @Test(expected=MessagingException.class)
    public void worksWithFirstFailingRouteAndSecondGood() throws Exception {
        CustomRouteResolver.routes.add(new CustomRouteResolver.FailingMessageProcessor());
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("b"));
        this.runFlowAndAssertResponse(this.getTestFlow(DYNAMIC_ALL), (Object)"doesnotmatter");
    }

    @Test(expected=MessagingException.class)
    public void worksWithFirstRouteGoodAndSecondFails() throws Exception {
        CustomRouteResolver.routes.add(new CustomRouteResolver.FailingMessageProcessor());
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("b"));
        this.runFlowAndAssertResponse(this.getTestFlow(DYNAMIC_ALL), (Object)"doesnotmatter");
    }

    @Test
    public void oneRoute() throws Exception {
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("a"));
        MuleEvent result = this.getTestFlow(DYNAMIC_ALL).process(DynamicAllTestCase.getTestEvent((Object)"Test Message"));
        Assert.assertThat((Object)result.getMessage().getPayloadAsString(), (Matcher)Is.is((Object)"a"));
    }

    @Test
    public void oneRouteWithCustomResultAggregator() throws Exception {
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("a"));
        this.runFlowAndAssertResponse((Flow)this.getFlowConstruct("dynamicAllResultAggregator"), DynamicAllTestCase.getTestEvent((Object)"Test Message"), "a");
    }

    private MuleEvent runFlowAndAssertResponse(Flow flow, String ... letters) throws Exception {
        return this.runFlowAndAssertResponse(flow, DynamicAllTestCase.getTestEvent((Object)"Test Message"), letters);
    }

    private MuleEvent runFlowAndAssertResponse(Flow flow, MuleEvent event, String ... letters) throws Exception {
        MuleEvent resultEvent = flow.process(event);
        MuleMessageCollection messageCollection = (MuleMessageCollection)resultEvent.getMessage();
        for (int i = 0; i < letters.length; ++i) {
            MuleMessage message = messageCollection.getMessage(i);
            Assert.assertThat((Object)message.getPayloadAsString(), (Matcher)Is.is((Object)letters[i]));
        }
        return resultEvent;
    }
}

