/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.test.routing.CustomRouteResolver;

public abstract class DynamicRouterTestCase
extends FunctionalTestCase {
    protected static final String LETTER_A = "a";
    protected static final String LETTER_B = "b";
    protected static final String LETTER_C = "c";
    protected static final String LETTER_D = "d";
    protected static final String DOES_NOT_MATTER = "doesnotmatter";

    @Before
    public void clearRoutes() {
        CustomRouteResolver.routes.clear();
    }

    @Test(expected=MessagingException.class)
    public void noRoutes() throws Exception {
        Flow flow = this.getTestFlow(this.getFlowName());
        flow.process(DynamicRouterTestCase.getTestEvent((Object)"Test Message"));
    }

    public abstract String getFlowName();

    protected MuleEvent runFlowAndAssertResponse(Flow flow, Object expectedMessage) throws Exception {
        MuleEvent event = flow.process(DynamicRouterTestCase.getTestEvent((Object)"Test Message"));
        Assert.assertThat((Object)event.getMessageAsString(), (Matcher)Is.is((Object)expectedMessage));
        return event;
    }

    protected Flow getTestFlow(String flow) throws Exception {
        return (Flow)this.getFlowConstruct(flow);
    }
}

