/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;

public class RedeliveryPolicyTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "redelivery-policy-test.xml";
    }

    @Test
    public void testSuccess() throws Exception {
        for (int i = 0; i < 100; ++i) {
            MuleClient client = new MuleClient(muleContext);
            client.send("vm://success", (Object)"hello", null);
        }
        this.checkNumberOfMessages("vm://dead-letter-queue", 0, 1000L);
    }

    @Test
    public void testLimitedFailures() throws Exception {
        int success = 0;
        int failure = 0;
        for (int i = 0; i < 100; ++i) {
            MuleClient client = new MuleClient(muleContext);
            MuleMessage msg = client.send("vm://limitedFailures", (Object)"hello", null);
            if (msg.getExceptionPayload() != null) {
                ++failure;
                continue;
            }
            if (!msg.getPayload().equals("hello")) continue;
            ++success;
        }
        this.checkNumberOfMessages("vm://dead-letter-queue", 0, 1000L);
        Assert.assertEquals((long)25L, (long)success);
        Assert.assertEquals((long)75L, (long)failure);
    }

    @Test
    public void testManyRealFailures() throws Exception {
        int success = 0;
        int failure = 0;
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 10; ++j) {
                MuleClient client = new MuleClient(muleContext);
                String payload = "hello" + j;
                MuleMessage msg = client.send("vm://manyRealFailures", (Object)payload, null);
                if (msg.getExceptionPayload() != null) {
                    ++failure;
                    continue;
                }
                if (!msg.getPayload().equals(payload)) continue;
                ++success;
            }
        }
        this.checkNumberOfMessages("vm://dead-letter-queue", 20, 1000L);
        Assert.assertEquals((long)10L, (long)success);
        Assert.assertEquals((long)90L, (long)failure);
    }

    protected void checkNumberOfMessages(String url, int size, long timeout) throws MuleException {
        int count = 0;
        MuleClient client = new MuleClient(muleContext);
        while (client.request(url, timeout) != null) {
            ++count;
        }
        Assert.assertEquals((long)size, (long)count);
    }

    public static class FailThreeOrSeven {
        static Map<String, Integer> counts = new HashMap<String, Integer>();

        public String process(String msg) {
            Integer icount = counts.get(msg);
            int count = icount == null ? 0 : icount;
            counts.put(msg, count + 1);
            if (count % 12 != 3 && count++ % 12 != 11) {
                throw new RuntimeException();
            }
            return msg;
        }
    }

    public static class FailThree {
        static int count = 0;

        public String process(String msg) {
            if (count++ % 4 != 0) {
                throw new RuntimeException();
            }
            return msg;
        }
    }
}

