/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;
import org.mule.api.ExceptionPayload;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.routing.AggregationContext;
import org.mule.api.routing.ResponseTimeoutException;
import org.mule.api.transport.DispatchException;
import org.mule.routing.AggregationStrategy;
import org.mule.routing.CompositeRoutingException;
import org.mule.tck.functional.FlowAssert;
import org.mule.tck.junit4.FunctionalTestCase;

public class ScatterGatherRouterTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "scatter-gather-test.xml";
    }

    @Test
    public void minimalConfiguration() throws Exception {
        this.testFlow("minimalConfig", ScatterGatherRouterTestCase.getTestEvent((Object)""));
    }

    @Test(expected=MessagingException.class)
    public void consumablePayload() throws Exception {
        this.testFlow("minimalConfig", ScatterGatherRouterTestCase.getTestEvent((Object)new ByteArrayInputStream("hello world".getBytes())));
    }

    @Test
    public void timeout() throws Exception {
        try {
            this.runFlow("timeout");
            Assert.fail((String)"Was expecting a timeout");
        }
        catch (CompositeRoutingException e) {
            MuleEvent response = e.getEvent();
            ExceptionPayload ep = response.getMessage().getExceptionPayload();
            Assert.assertNotNull((Object)ep);
            Assert.assertSame((Object)((Object)e), (Object)ep.getException());
            Map exceptions = e.getExceptions();
            Assert.assertEquals((int)1, (int)exceptions.size());
            Assert.assertTrue((boolean)(exceptions.get(2) instanceof ResponseTimeoutException));
        }
    }

    @Test
    public void routeWithException() throws Exception {
        try {
            this.runFlow("routeWithException");
            Assert.fail((String)"Was expecting a failure");
        }
        catch (CompositeRoutingException e) {
            MuleEvent response = e.getEvent();
            ExceptionPayload ep = response.getMessage().getExceptionPayload();
            Assert.assertNotNull((Object)ep);
            Assert.assertSame((Object)((Object)e), (Object)ep.getException());
            Map exceptions = e.getExceptions();
            Assert.assertEquals((int)1, (int)exceptions.size());
            Assert.assertTrue((boolean)(exceptions.get(1) instanceof DispatchException));
        }
    }

    @Test
    public void customMergeStrategyByName() throws Exception {
        this.testFlow("customMergeStrategyByName", ScatterGatherRouterTestCase.getTestEvent((Object)""));
    }

    @Test
    public void customMergeStrategyByRef() throws Exception {
        this.testFlow("customMergeStrategyByRef", ScatterGatherRouterTestCase.getTestEvent((Object)""));
    }

    @Test
    public void customThreadingProfile() throws Exception {
        Date start = new Date();
        this.runFlow("customThreadingProfile", "");
        Date end = new Date();
        long waitTime = end.getTime() - start.getTime();
        Assert.assertTrue((String)String.format("it only took %d ms", waitTime), (waitTime >= 5000L ? 1 : 0) != 0);
        FlowAssert.verify((String)"customThreadingProfile");
    }

    @Test
    public void requestResponseInboundEndpoint() throws Exception {
        muleContext.getClient().send("vm://requestResponseInboundEndpoint", ScatterGatherRouterTestCase.getTestEvent((Object)"").getMessage());
        FlowAssert.verify((String)"requestResponseInboundEndpoint");
    }

    @Test
    public void oneWayInboundEndpoint() throws Exception {
        muleContext.getClient().send("vm://oneWayInboundEndpoint", ScatterGatherRouterTestCase.getTestEvent((Object)"").getMessage());
        FlowAssert.verify((String)"oneWayInboundEndpoint");
    }

    @Test
    public void routesWithForeachAndInboundEndpoint() throws Exception {
        String[] payload = new String[]{"apple", "banana", "orange"};
        muleContext.getClient().send("vm://routesWithForeachAndInboundEndpoint", ScatterGatherRouterTestCase.getTestEvent(Arrays.asList(payload)).getMessage());
        FlowAssert.verify((String)"routesWithForeachAndInboundEndpoint");
    }

    @Test
    public void exceptionStrategy() throws Exception {
        this.testFlow("exceptionStrategy", ScatterGatherRouterTestCase.getTestEvent((Object)""));
    }

    @Test
    public void failingMergeStrategy() throws Exception {
        try {
            this.runFlow("failingMergeStrategy", ScatterGatherRouterTestCase.getTestEvent((Object)""));
            Assert.fail((String)"Was expecting a exception");
        }
        catch (MessagingException e) {
            Assert.assertEquals(UnsupportedOperationException.class, e.getCause().getClass());
        }
    }

    @Test
    public void messageProperties() throws Exception {
        this.testFlow("messageProperties", ScatterGatherRouterTestCase.getTestEvent((Object)""));
    }

    @Test
    public void oneWayRouteWithSingleResponse() throws Exception {
        muleContext.getClient().send("vm://oneWayRouteWithSingleResponse", ScatterGatherRouterTestCase.getTestEvent((Object)"").getMessage());
        FlowAssert.verify((String)"oneWayRouteWithSingleResponse");
    }

    @Test
    public void oneWayRouteWithMultipleResponses() throws Exception {
        muleContext.getClient().send("vm://oneWayRouteWithMultipleResponses", ScatterGatherRouterTestCase.getTestEvent((Object)"").getMessage());
        FlowAssert.verify((String)"oneWayRouteWithMultipleResponses");
    }

    @Test
    public void oneWayRoutesOnly() throws Exception {
        muleContext.getClient().send("vm://oneWayRoutesOnly", ScatterGatherRouterTestCase.getTestEvent((Object)"").getMessage());
        FlowAssert.verify((String)"oneWayRoutesOnly");
    }

    public static class FailingAggregationStrategy
    implements AggregationStrategy {
        public MuleEvent aggregate(AggregationContext context) throws MuleException {
            throw new UnsupportedOperationException();
        }
    }

    public static class TestAggregationStrategy
    implements AggregationStrategy {
        public MuleEvent aggregate(AggregationContext context) throws MuleException {
            StringBuilder builder = new StringBuilder();
            for (MuleEvent event : context.getEvents()) {
                if (builder.length() > 0) {
                    builder.append(' ');
                }
                builder.append(event.getMessage().getPayload());
            }
            context.getOriginalEvent().getMessage().setPayload((Object)builder.toString());
            return context.getOriginalEvent();
        }
    }
}

