/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.io.Serializable;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.construct.Flow;
import org.mule.endpoint.DefaultEndpointFactory;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.util.endpoint.InboundEndpointWrapper;
import org.mule.util.concurrent.Latch;

public class SynchronizedMuleContextStartTestCase
extends FunctionalTestCase {
    private static volatile int processedMessageCounter = 0;
    private static Latch waitMessageInProgress = new Latch();

    public SynchronizedMuleContextStartTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigFile() {
        return "synchronized-mule-context-start-config.xml";
    }

    @Test
    public void waitsForStartedMuleContextBeforeAttemptingToSendMessageToEndpoint() throws Exception {
        this.prePopulateObjectStore();
        muleContext.start();
        PollingProber prober = new PollingProber(5000L, 50L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                return processedMessageCounter == 1;
            }

            public String describeFailure() {
                return "Did not wait for mule context started before attempting to process event";
            }
        });
    }

    private void prePopulateObjectStore() throws ObjectStoreException {
        ObjectStore objectStore = (ObjectStore)muleContext.getRegistry().lookupObject("objectStore");
        DefaultMuleMessage testMessage = new DefaultMuleMessage((Object)"Test Message", muleContext);
        Flow clientFlow = (Flow)muleContext.getRegistry().get("flow2");
        DefaultMuleEvent testMuleEvent = new DefaultMuleEvent((MuleMessage)testMessage, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)clientFlow);
        objectStore.store((Serializable)((Object)testMuleEvent.getId()), (Serializable)testMuleEvent);
    }

    public static class DelayedStartInboundEndpointWrapper
    extends InboundEndpointWrapper {
        public DelayedStartInboundEndpointWrapper(InboundEndpoint delegate) {
            super(delegate);
        }

        public void start() throws MuleException {
            try {
                waitMessageInProgress.await();
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            super.start();
        }
    }

    public static class DelayedStartEndpointFactory
    extends DefaultEndpointFactory {
        public InboundEndpoint getInboundEndpoint(EndpointBuilder builder) throws MuleException {
            InboundEndpoint endpoint = builder.buildInboundEndpoint();
            if (endpoint.getName().equals("endpoint.vm.flow2")) {
                DelayedStartInboundEndpointWrapper wrappedEndpoint = new DelayedStartInboundEndpointWrapper(endpoint);
                return (InboundEndpoint)this.registerEndpoint((ImmutableEndpoint)wrappedEndpoint);
            }
            return (InboundEndpoint)this.registerEndpoint((ImmutableEndpoint)endpoint);
        }
    }

    public static class UnblockEndpointStart {
        public void unclockEndpoint(String value) {
            waitMessageInProgress.release();
        }
    }

    public static class ProcessedMessageCounter {
        public String count(String value) {
            processedMessageCounter++;
            return value;
        }
    }
}

