/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutingException;
import org.mule.construct.Flow;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.functional.InvocationCountMessageProcessor;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.util.store.AbstractPartitionedObjectStore;

@RunWith(value=Parameterized.class)
public class UntilSuccessfulTestCase
extends FunctionalTestCase {
    private final String configFile;
    private MuleClient client;
    private FunctionalTestComponent targetMessageProcessor;
    private FunctionalTestComponent deadLetterQueueProcessor;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"until-successful-test.xml"}, {"until-successful-seconds-test.xml"});
    }

    public UntilSuccessfulTestCase(String configFile) {
        this.configFile = configFile;
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.client = muleContext.getClient();
        this.targetMessageProcessor = this.getFunctionalTestComponent("target-mp");
        this.deadLetterQueueProcessor = this.getFunctionalTestComponent("dlq-processor");
        AbstractPartitionedObjectStore objectStore = (AbstractPartitionedObjectStore)muleContext.getRegistry().lookupObject("objectStore");
        objectStore.disposePartition("DEFAULT_PARTITION");
    }

    @Test
    public void testDefaultConfiguration() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        this.client.dispatch("vm://input-1", (Object)payload, null);
        List<Object> receivedPayloads = this.ponderUntilMessageCountReceivedByTargetMessageProcessor(1);
        Assert.assertEquals((long)1L, (long)receivedPayloads.size());
        Assert.assertEquals((Object)payload, (Object)receivedPayloads.get(0));
    }

    @Test
    public void testFullConfiguration() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        MuleMessage response = this.client.send("vm://input-2", (Object)payload, null);
        Assert.assertEquals((Object)"ACK", (Object)response.getPayloadAsString());
        List<Object> receivedPayloads = this.ponderUntilMessageCountReceivedByTargetMessageProcessor(3);
        Assert.assertEquals((long)3L, (long)receivedPayloads.size());
        for (int i = 0; i <= 2; ++i) {
            Assert.assertEquals((Object)payload, (Object)receivedPayloads.get(i));
        }
        receivedPayloads = this.ponderUntilMessageCountReceivedByDlqProcessor(1);
        Assert.assertEquals((long)1L, (long)receivedPayloads.size());
        Assert.assertEquals((Object)payload, (Object)receivedPayloads.get(0));
    }

    @Test
    public void testFullConfigurationMP() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        MuleMessage response = this.client.send("vm://input-2MP", (Object)payload, null);
        Assert.assertEquals((Object)"ACK", (Object)response.getPayloadAsString());
        List<Object> receivedPayloads = this.ponderUntilMessageCountReceivedByTargetMessageProcessor(3);
        Assert.assertEquals((long)3L, (long)receivedPayloads.size());
        for (int i = 0; i <= 2; ++i) {
            Assert.assertEquals((Object)payload, (Object)receivedPayloads.get(i));
        }
        this.ponderUntilMessageCountReceivedByCustomMP(1);
    }

    @Test
    public void testRetryOnEndpoint() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        this.client.dispatch("vm://input-3", (Object)payload, null);
        List<Object> receivedPayloads = this.ponderUntilMessageCountReceivedByTargetMessageProcessor(3);
        Assert.assertEquals((long)3L, (long)receivedPayloads.size());
        for (int i = 0; i <= 2; ++i) {
            Assert.assertEquals((Object)payload, (Object)receivedPayloads.get(i));
        }
    }

    @Test(expected=RoutingException.class)
    public void executeSynchronously() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        Flow flow = (Flow)this.getFlowConstruct("synchronous");
        flow.process(UntilSuccessfulTestCase.getTestEvent((Object)payload));
        Assert.fail((String)"Exception should be thrown");
    }

    @Test
    public void executeSynchronouslyDoingRetries() throws Exception {
        try {
            String payload = RandomStringUtils.randomAlphanumeric((int)20);
            Flow flow = (Flow)this.getFlowConstruct("synchronous-with-retry");
            flow.process(UntilSuccessfulTestCase.getTestEvent((Object)payload));
            Assert.fail((String)"Exception should be thrown");
        }
        catch (Exception e) {
            Assert.assertThat((Object)InvocationCountMessageProcessor.getNumberOfInvocationsFor((String)"untilSuccessful"), (Matcher)Is.is((Object)4));
            Assert.assertThat((Object)InvocationCountMessageProcessor.getNumberOfInvocationsFor((String)"exceptionStrategy"), (Matcher)Is.is((Object)1));
        }
    }

    @Test
    public void measureSynchronousWait() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        Flow flow = (Flow)this.getFlowConstruct("measureSynchronousWait");
        try {
            flow.process(UntilSuccessfulTestCase.getTestEvent((Object)payload));
            Assert.fail((String)"Exception should be thrown");
        }
        catch (Exception e) {
            Assert.assertThat((Object)(WaitMeasure.totalWait >= 1000L ? 1 : 0), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void executeAsynchronouslyDoingRetries() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        int expectedCounterExecutions = 4;
        boolean expectedCounterInExceptionStrategyExecutions = true;
        Flow flow = (Flow)this.getFlowConstruct("asynchronous-using-threading-profile");
        flow.process(UntilSuccessfulTestCase.getTestEvent((Object)payload));
        new PollingProber(10000L, 100L).check(new Probe(){
            private int executionOfCountInUntilSuccessful;
            private int executionOfCountInExceptionStrategy;

            public boolean isSatisfied() {
                this.executionOfCountInUntilSuccessful = InvocationCountMessageProcessor.getNumberOfInvocationsFor((String)"untilSuccessful2");
                this.executionOfCountInExceptionStrategy = InvocationCountMessageProcessor.getNumberOfInvocationsFor((String)"exceptionStrategy2");
                return this.executionOfCountInUntilSuccessful == 4 && this.executionOfCountInExceptionStrategy == 1;
            }

            public String describeFailure() {
                return String.format("Expecting %d executions of counter in until-successful and got %d \n Expecting %d execution of counter in exception strategy and got %d", 4, this.executionOfCountInUntilSuccessful, 1, this.executionOfCountInExceptionStrategy);
            }
        });
    }

    @Test
    public void executeAsynchronouslyDoingRetriesAfterRestart() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("asynchronous-using-threading-profile");
        flow.stop();
        flow.start();
        this.executeAsynchronouslyDoingRetries();
    }

    private List<Object> ponderUntilMessageCountReceivedByTargetMessageProcessor(int expectedCount) throws InterruptedException {
        return this.ponderUntilMessageCountReceived(expectedCount, this.targetMessageProcessor);
    }

    private List<Object> ponderUntilMessageCountReceivedByDlqProcessor(int expectedCount) throws InterruptedException {
        return this.ponderUntilMessageCountReceived(expectedCount, this.deadLetterQueueProcessor);
    }

    private List<Object> ponderUntilMessageCountReceived(int expectedCount, FunctionalTestComponent ftc) throws InterruptedException {
        ArrayList<Object> results = new ArrayList<Object>();
        while (ftc.getReceivedMessagesCount() < expectedCount) {
            Thread.yield();
            Thread.sleep(100L);
        }
        for (int i = 0; i < ftc.getReceivedMessagesCount(); ++i) {
            results.add(ftc.getReceivedMessage(1 + i));
        }
        return results;
    }

    private void ponderUntilMessageCountReceivedByCustomMP(int expectedCount) throws InterruptedException {
        while (CustomMP.getCount() < expectedCount) {
            Thread.yield();
            Thread.sleep(100L);
        }
    }

    static class WaitMeasure
    implements MessageProcessor {
        public static long totalWait;
        private long firstAttemptTime = 0L;

        WaitMeasure() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            if (this.firstAttemptTime == 0L) {
                this.firstAttemptTime = System.currentTimeMillis();
            } else {
                totalWait = System.currentTimeMillis() - this.firstAttemptTime;
            }
            return event;
        }
    }

    static class CustomMP
    implements MessageProcessor {
        private static int count;

        CustomMP() {
        }

        public static void clearCount() {
            count = 0;
        }

        public static int getCount() {
            return count;
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            ++count;
            return null;
        }
    }
}

