/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.transformers;

import java.io.InputStream;
import org.apache.tools.ant.filters.StringInputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public class ImplicitTransformationTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/transformers/implicit-transformation-config.xml";
    }

    @Test
    public void testImplicitInputStreamToStringConversion() throws Exception {
        StringInputStream inputStream = new StringInputStream("TEST");
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://stringInput", (Object)inputStream, null);
        Assert.assertEquals((Object)"TSET", (Object)response.getPayload());
    }

    @Test
    public void testImplicitByteArrayToStringConversion() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://stringInput", (Object)"TEST".getBytes(), null);
        Assert.assertEquals((Object)"TSET", (Object)response.getPayload());
    }

    @Test
    public void testImplicitInputStreamToByteArrayConversion() throws Exception {
        StringInputStream inputStream = new StringInputStream("TEST");
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://byteArrayInput", (Object)inputStream, null);
        Assert.assertEquals((Object)"TSET", (Object)response.getPayload());
    }

    @Test
    public void testImplicitStringToByteArrayConversion() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://byteArrayInput", (Object)"TEST", null);
        Assert.assertEquals((Object)"TSET", (Object)response.getPayload());
    }

    @Test
    public void testImplicitStringToInputStreamConversion() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://inputStreamInput", (Object)"TEST", null);
        Assert.assertEquals((Object)"TSET", (Object)response.getPayload());
    }

    @Test
    public void testImplicitByteArrayToInputStreamConversion() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://inputStreamInput", (Object)"TEST".getBytes(), null);
        Assert.assertEquals((Object)"TSET", (Object)response.getPayload());
    }

    public static class TestInputStreamTransformer
    extends AbstractTransformer {
        public TestInputStreamTransformer() {
            this.registerSourceType(DataTypeFactory.INPUT_STREAM);
            this.setReturnDataType(DataTypeFactory.STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doTransform(Object src, String enc) throws TransformerException {
            String stringValue;
            InputStream input = (InputStream)src;
            try {
                stringValue = IOUtils.toString((InputStream)input);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
            return StringUtils.reverse((String)stringValue);
        }
    }

    public static class TestByteArrayTransformer
    extends AbstractTransformer {
        public TestByteArrayTransformer() {
            this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
            this.setReturnDataType(DataTypeFactory.STRING);
        }

        protected Object doTransform(Object src, String enc) throws TransformerException {
            return StringUtils.reverse((String)new String((byte[])src));
        }
    }

    public static class TestStringTransformer
    extends AbstractTransformer {
        public TestStringTransformer() {
            this.registerSourceType(DataTypeFactory.STRING);
            this.setReturnDataType(DataTypeFactory.STRING);
        }

        protected Object doTransform(Object src, String enc) throws TransformerException {
            return StringUtils.reverse((String)((String)src));
        }
    }
}

