/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.annotations.param;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.activation.DataHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.NullPayload;
import org.mule.util.ExceptionUtils;

public class OutboundAttachmentsAnnotationTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/annotations/outbound-attachments-annotation-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/annotations/outbound-attachments-annotation-flow.xml"});
    }

    public OutboundAttachmentsAnnotationTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setDisposeContextPerClass(true);
    }

    @Test
    public void testProcessAttachment() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachment", OutboundAttachmentsAnnotationTestCase.getTestMuleMessage((Object)NullPayload.getInstance()));
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map<String, DataHandler> result = this.getMapPayload(message);
        Assert.assertEquals((Object)"barValue", (Object)result.get("bar").getContent());
    }

    @Test
    public void testProcessAttachmentWithExistingOutAttachments() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://attachment2", OutboundAttachmentsAnnotationTestCase.getTestMuleMessage((Object)NullPayload.getInstance()));
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map<String, DataHandler> result = this.getMapPayload(message);
        Assert.assertEquals((Object)"barValue", (Object)result.get("bar").getContent());
        Assert.assertEquals((Object)"fooValue", (Object)result.get("foo").getContent());
    }

    @Test
    public void testInvalidParamType() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://invalid", OutboundAttachmentsAnnotationTestCase.getTestMuleMessage((Object)NullPayload.getInstance()));
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(IllegalArgumentException.class, ExceptionUtils.getRootCause((Throwable)message.getExceptionPayload().getException()).getClass());
    }

    private Map<String, DataHandler> getMapPayload(MuleMessage message) {
        return (Map)message.getPayload();
    }
}

