/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.io.IOException;
import org.apache.commons.collections.map.HashedMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mule.config.spring.AbstractSchemaValidationTestCase;
import org.xml.sax.SAXException;

public class InvalidSchemaValidationTestCase
extends AbstractSchemaValidationTestCase {
    @After
    public void doCleanUp() {
        this.schemas = new HashedMap();
    }

    @Test(expected=SAXException.class)
    public void testTransformerReference() throws SAXException, IOException {
        this.addSchema("http://www.mulesoft.org/schema/mule/vm", "META-INF/mule-vm.xsd");
        this.doTest("org/mule/config/spring/schema-validation-transformer-ref-test.xml");
    }

    @Test(expected=SAXException.class)
    public void testFilterReference() throws SAXException, IOException {
        this.addSchema("http://www.mulesoft.org/schema/mule/vm", "META-INF/mule-vm.xsd");
        this.doTest("org/mule/config/spring/schema-validation-filter-ref-test.xml");
    }

    @Test
    public void testTransactedConnectors() throws SAXException, IOException {
        this.addSchema("http://www.mulesoft.org/schema/mule/vm", "META-INF/mule-vm.xsd");
        this.addSchema("http://www.mulesoft.org/schema/mule/jdbc", "META-INF/mule-jdbc.xsd");
        this.addSchema("http://www.springframework.org/schema/beans", "http://www.springframework.org/schema/beans/spring-beans-3.1.xsd");
        this.doTest("org/mule/config/spring/schema-validation-transacted-connectors-test.xml");
    }

    @Test(expected=SAXException.class)
    public void testNotTransactedFileConnector() throws SAXException, IOException {
        this.addSchema("http://www.mulesoft.org/schema/mule/file", "META-INF/mule-file.xsd");
        this.doTest("org/mule/config/spring/schema-validation-not-transacted-file-connector-test.xml");
    }

    @Test(expected=SAXException.class)
    public void testNotTransactedFtpConnector() throws SAXException, IOException {
        this.addSchema("http://www.mulesoft.org/schema/mule/ftp", "META-INF/mule-ftp.xsd");
        this.doTest("org/mule/config/spring/schema-validation-not-transacted-ftp-connector-test.xml");
    }

    @Test
    public void testJdbcInvalidPollingFrequencyInOutboundEndpoint() throws SAXException, IOException {
        this.addSchema("http://www.mulesoft.org/schema/mule/jdbc", "META-INF/mule-jdbc.xsd");
        this.addSchema("http://www.mulesoft.org/schema/mule/test", "http://www.mulesoft.org/schema/mule/test/3.2/mule-test.xsd");
        try {
            this.doTest("org/mule/config/spring/schema-validation-jdbc-invalid-polling-frequency.xml");
        }
        catch (SAXException e) {
            Assert.assertTrue((e.getMessage() != null && e.getMessage().contains("jdbc:outbound-endpoint") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testExpressionPattern() throws SAXException, IOException {
        this.doTest("org/mule/config/spring/schema-validation-expression-pattern-test.xml");
    }

    @Test
    public void testRouterWithFilter() throws SAXException, IOException {
        this.addSchema("http://www.mulesoft.org/schema/mule/vm", "META-INF/mule-vm.xsd");
        this.doTest("org/mule/config/spring/schema-validation-router-filter-test.xml");
    }
}

