/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import java.util.Collection;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.SecurityNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.security.SecurityException;
import org.mule.api.security.UnauthorisedException;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.ListenerSubscriptionPair;
import org.mule.context.notification.SecurityNotification;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.NullPayload;

public class ServerNotificationManagerTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/config/spring/parsers/specific/server-notification-manager-test.xml";
    }

    @Test
    public void testDynamicAttribute() {
        ServerNotificationManager manager = muleContext.getNotificationManager();
        Assert.assertTrue((boolean)manager.isNotificationDynamic());
    }

    @Test
    public void testRoutingConfiguration() {
        ServerNotificationManager manager = muleContext.getNotificationManager();
        Assert.assertTrue((manager.getInterfaceToTypes().size() > 2 ? 1 : 0) != 0);
        Object ifaces = manager.getInterfaceToTypes().get(TestInterface.class);
        Assert.assertNotNull(ifaces);
        Assert.assertTrue((boolean)(ifaces instanceof Collection));
        Assert.assertTrue((boolean)((Collection)ifaces).contains(TestEvent.class));
        ifaces = manager.getInterfaceToTypes().get(TestInterface2.class);
        Assert.assertNotNull(ifaces);
        Assert.assertTrue((boolean)(ifaces instanceof Collection));
        Assert.assertTrue((boolean)((Collection)ifaces).contains(SecurityNotification.class));
    }

    @Test
    public void testSimpleNotification() throws InterruptedException {
        ServerNotificationManager manager = muleContext.getNotificationManager();
        Set listeners = manager.getListeners();
        Assert.assertTrue((listeners.size() > 5 ? 1 : 0) != 0);
        TestListener listener = (TestListener)muleContext.getRegistry().lookupObject("listener");
        Assert.assertNotNull((Object)listener);
        Assert.assertFalse((boolean)listener.isCalled());
        manager.fireNotification((ServerNotification)new TestEvent());
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)listener.isCalled());
    }

    @Test
    public void testExplicitlyConiguredNotificationListenerRegistration() throws InterruptedException {
        ServerNotificationManager manager = muleContext.getNotificationManager();
        Assert.assertTrue((boolean)manager.getListeners().contains(new ListenerSubscriptionPair((ServerNotificationListener)muleContext.getRegistry().lookupObject("listener"), null)));
        Assert.assertTrue((boolean)manager.getListeners().contains(new ListenerSubscriptionPair((ServerNotificationListener)muleContext.getRegistry().lookupObject("listener2"), null)));
        Assert.assertTrue((boolean)manager.getListeners().contains(new ListenerSubscriptionPair((ServerNotificationListener)muleContext.getRegistry().lookupObject("securityListener"), null)));
        Assert.assertTrue((boolean)manager.getListeners().contains(new ListenerSubscriptionPair((ServerNotificationListener)muleContext.getRegistry().lookupObject("listener3"), "*")));
    }

    @Test
    public void testAdhocNotificationListenerRegistrations() throws InterruptedException {
        ServerNotificationManager manager = muleContext.getNotificationManager();
        Assert.assertFalse((boolean)manager.getListeners().contains(new ListenerSubscriptionPair((ServerNotificationListener)muleContext.getRegistry().lookupObject("listener3"), null)));
        Assert.assertTrue((boolean)manager.getListeners().contains(new ListenerSubscriptionPair((ServerNotificationListener)muleContext.getRegistry().lookupObject("listener4"), null)));
    }

    @Test
    public void testDisabledNotification() throws Exception {
        ServerNotificationManager manager = muleContext.getNotificationManager();
        Set listeners = manager.getListeners();
        Assert.assertTrue((listeners.size() > 5 ? 1 : 0) != 0);
        TestListener2 listener2 = (TestListener2)muleContext.getRegistry().lookupObject("listener2");
        Assert.assertNotNull((Object)listener2);
        Assert.assertFalse((boolean)listener2.isCalled());
        TestSecurityListener adminListener = (TestSecurityListener)muleContext.getRegistry().lookupObject("securityListener");
        Assert.assertNotNull((Object)adminListener);
        Assert.assertFalse((boolean)adminListener.isCalled());
        manager.fireNotification((ServerNotification)new TestSecurityEvent(muleContext));
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)listener2.isCalled());
        Assert.assertFalse((boolean)adminListener.isCalled());
    }

    protected static class TestSecurityEvent
    extends SecurityNotification {
        public TestSecurityEvent(MuleContext muleContext) throws Exception {
            super((SecurityException)new UnauthorisedException(CoreMessages.createStaticMessage((String)"dummy"), (MuleEvent)new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)NullPayload.getInstance(), muleContext), MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)AbstractMuleContextTestCase.getTestService(), AbstractMuleContextTestCase.getTestSession(null, (MuleContext)muleContext))), 0);
        }
    }

    protected static class TestEvent
    extends ServerNotification {
        public TestEvent() {
            super(new Object(), 0);
        }
    }

    protected static class TestSecurityListener
    implements SecurityNotificationListener<SecurityNotification> {
        private boolean called = false;

        protected TestSecurityListener() {
        }

        public boolean isCalled() {
            return this.called;
        }

        public void onNotification(SecurityNotification notification) {
            this.called = true;
        }
    }

    protected static class TestListener2
    implements TestInterface2 {
        private boolean called = false;

        protected TestListener2() {
        }

        public boolean isCalled() {
            return this.called;
        }

        public void onNotification(ServerNotification notification) {
            this.called = true;
        }
    }

    protected static class TestListener
    implements TestInterface {
        private boolean called = false;

        protected TestListener() {
        }

        public boolean isCalled() {
            return this.called;
        }

        public void onNotification(ServerNotification notification) {
            this.called = true;
        }
    }

    protected static interface TestInterface2
    extends ServerNotificationListener {
    }

    protected static interface TestInterface
    extends ServerNotificationListener {
    }
}

