/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.config.ConfigurationException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.ApplicationContextBuilder;
import org.mule.test.integration.lifecycle.LifecycleBean;

public class MuleContextLifecycleTestCase
extends AbstractMuleContextTestCase {
    private static final String EXPECTED_A_CONTEXT_START_EXCEPTION_EXCEPTION = "Expected a ContextStartException exception";

    @Test
    public void failOnStartInvokesStopInOtherComponentsButNotInTheFailedOne() throws Exception {
        LifecycleBean lifecycleBean = this.getBeanFromContext("component-failing-during-startup-config.xml");
        LifecycleBean failOnStartLifecycleBean = (LifecycleBean)lifecycleBean.getMuleContext().getRegistry().get("failOnStartLifecycleBean");
        LifecycleBean lifecycleBeanFromMuleContext = (LifecycleBean)lifecycleBean.getMuleContext().getRegistry().get("lifecycleBean");
        lifecycleBean.getMuleContext().dispose();
        Assert.assertThat(lifecycleBeanFromMuleContext.getLifecycleInvocations(), (Matcher)Matchers.contains((Object[])new String[]{"initialise", "start", "stop", "dispose"}));
        Assert.assertThat(failOnStartLifecycleBean.getLifecycleInvocations(), (Matcher)Matchers.contains((Object[])new String[]{"initialise", "start", "dispose"}));
    }

    @Test(expected=ConfigurationException.class)
    public void failOnInitialiseInvokesStopInOtherComponentsButNotInTheFailedOne() throws Exception {
        this.getBeanFromContext("component-failing-during-initialise-config.xml");
    }

    private LifecycleBean getBeanFromContext(String resource) throws Exception {
        LifecycleBean lifecycleBean = null;
        try {
            muleContext = new ApplicationContextBuilder().setApplicationResources(new String[]{resource}).build();
            Assert.fail((String)EXPECTED_A_CONTEXT_START_EXCEPTION_EXCEPTION);
        }
        catch (LifecycleException e) {
            lifecycleBean = (LifecycleBean)e.getComponent();
        }
        return lifecycleBean;
    }
}

