/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import org.junit.After;
import org.junit.Assert;
import org.mule.api.context.notification.ServerNotification;
import org.mule.context.notification.NotificationLogger;
import org.mule.context.notification.RestrictedNode;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public abstract class AbstractNotificationTestCase
extends AbstractServiceAndFlowTestCase {
    private NotificationLogger notificationLogger;

    public AbstractNotificationTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @After
    public void clearNotifications() {
        if (this.notificationLogger != null) {
            this.notificationLogger.getNotifications().clear();
        }
    }

    protected void assertNotifications() {
        this.notificationLogger = (NotificationLogger)muleContext.getRegistry().lookupObject("notificationLogger");
        muleContext.dispose();
        PollingProber prober = new PollingProber(30000L, 2000L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                String notificationsLog = AbstractNotificationTestCase.this.buildLogNotifications();
                RestrictedNode spec = AbstractNotificationTestCase.this.getSpecification();
                AbstractNotificationTestCase.this.validateSpecification(spec);
                AbstractNotificationTestCase.this.assertExpectedNotifications(notificationsLog, spec);
                return true;
            }
        });
    }

    public abstract RestrictedNode getSpecification();

    public abstract void validateSpecification(RestrictedNode var1) throws Exception;

    protected String buildLogNotifications() {
        StringBuilder logMessageBuilder = new StringBuilder();
        logMessageBuilder.append("Number of notifications: " + this.notificationLogger.getNotifications().size() + System.lineSeparator());
        for (ServerNotification notification : this.notificationLogger.getNotifications()) {
            logMessageBuilder.append("\t" + notification + System.lineSeparator());
        }
        return logMessageBuilder.toString();
    }

    protected void assertExpectedNotifications(String notificationsLog, RestrictedNode spec) {
        for (ServerNotification notification : this.notificationLogger.getNotifications()) {
            switch (spec.match(notification)) {
                case 0: {
                    break;
                }
                case 1: {
                    Assert.fail((String)("Could not match " + notification + System.lineSeparator() + notificationsLog));
                    break;
                }
                case 2: {
                    Assert.fail((String)("Extra notification: " + notification + System.lineSeparator() + notificationsLog));
                }
            }
        }
        if (!spec.isExhausted()) {
            Assert.fail((String)("Specification not exhausted: " + spec.getAnyRemaining() + System.lineSeparator() + notificationsLog));
        }
    }

    protected void verifyAllNotifications(RestrictedNode spec, Class<?> clazz, int from, int to) {
        for (int action = from; action <= to; ++action) {
            if (spec.contains(clazz, action)) continue;
            Assert.fail((String)("Specification missed action " + action + " for class " + clazz));
        }
    }

    protected void verifyNotification(RestrictedNode spec, Class<?> clazz, int action) {
        if (!spec.contains(clazz, action)) {
            Assert.fail((String)("Specification missed action " + action + " for class " + clazz));
        }
    }
}

