/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import org.junit.Test;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class FailingNotificationListenerTestCase
extends FunctionalTestCase {
    private static int count = 0;
    private static final Object lock = new Object();

    protected String getConfigFile() {
        return "org/mule/test/integration/notifications/failing-notification-listener-config.xml";
    }

    @Test
    public void testName() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://testInput", (Object)"Test Message", null);
        client.dispatch("vm://testInput", (Object)"Test Message", null);
        PollingProber prober = new PollingProber(1000L, 10L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                return count == 2;
            }

            public String describeFailure() {
                return "Expected to received 2 notifications but received " + count;
            }
        });
    }

    public static class ExceptionFailingListener
    implements ExceptionNotificationListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNotification(ServerNotification notification) {
            Object object = lock;
            synchronized (object) {
                count = count + 1;
            }
            throw new IllegalStateException();
        }
    }
}

