/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification.processors;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.Factory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.client.MuleClient;
import org.mule.context.notification.Node;
import org.mule.context.notification.RestrictedNode;
import org.mule.context.notification.processors.AbstractMessageProcessorNotificationTestCase;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class MessageProcessorNotificationTestCase
extends AbstractMessageProcessorNotificationTestCase {
    private MuleClient client;
    private Factory specificationFactory;

    public MessageProcessorNotificationTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/notifications/message-processor-notification-test-flow.xml"}});
    }

    @Before
    public void before() {
        this.client = muleContext.getClient();
    }

    @Test
    public void single() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.prePost());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://in-single", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void chain() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://in-processorChain", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void customProcessor() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://customProcessor", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void choice() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://in-choice", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void scatterGather() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.pre()).serial(new Node().parallelSynch(MessageProcessorNotificationTestCase.this.pre().serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post())).parallelSynch(MessageProcessorNotificationTestCase.this.prePost())).serial(MessageProcessorNotificationTestCase.this.post());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://in-scatterGather", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void foreach() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post()).serial(MessageProcessorNotificationTestCase.this.prePost());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://in-foreach", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void enricher() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post()).serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://in-enricher", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    @Ignore(value="This is unstable")
    public void async() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://in-async", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void filter() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://in-filter", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void idempotentMessageFilter() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://idem-msg-filter", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void idempotentSecureHashMessageFilter() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://idem-sh-msg-filter", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void subFlow() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post()).serial(MessageProcessorNotificationTestCase.this.post());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://in-subflow", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void catchExceptionStrategy() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://in-catch", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void rollbackExceptionStrategy() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://in-rollback", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void choiceExceptionStrategy() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://in-choice-es", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void requestReply() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post()).serial(MessageProcessorNotificationTestCase.this.prePost());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://request-reply", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void compositeSource() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://cs1", (Object)"test", null));
        Assert.assertNotNull((Object)this.client.send("vm://cs2", (Object)"test", null));
        Assert.assertNotNull((Object)this.client.send("vm://cs3", (Object)"test", null));
        Assert.assertNotNull((Object)this.client.send("vm://cs4", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void firstSuccessful() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://fsucc", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void roundRobin() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post()).serial(MessageProcessorNotificationTestCase.this.prePost());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://round-robin", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void recipientList() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://recipient-list", (Object)"recipient", null));
        this.assertNotifications();
    }

    @Test
    public void collectionAggregator() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post());
            }
        };
        List<String> testList = Arrays.asList("test", "with", "collection");
        Assert.assertNotNull((Object)this.client.send("vm://collection-agg", testList, null));
        this.assertNotifications();
    }

    @Test
    public void customAggregator() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post()).serial(MessageProcessorNotificationTestCase.this.post());
            }
        };
        List<String> testList = Arrays.asList("test", "with", "collection");
        Assert.assertNotNull((Object)this.client.send("vm://custom-agg", testList, null));
        this.assertNotifications();
    }

    @Test
    public void chunkAggregator() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.pre()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post()).serial(MessageProcessorNotificationTestCase.this.post());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://chunk-agg", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void wireTap() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost());
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://wire-tap", (Object)"test", null));
        this.assertNotifications();
    }

    @Test
    public void untilSuccesful() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.pre()).serial(new Node().parallelSynch(MessageProcessorNotificationTestCase.this.prePost()).parallelSynch(MessageProcessorNotificationTestCase.this.post().serial(MessageProcessorNotificationTestCase.this.prePost())));
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://until-successful", (Object)"test", null));
        this.client.request("vm://out-us", 5000L);
        this.assertNotifications();
    }

    @Test
    public void untilSuccesfulWithProcessorChain() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.pre()).serial(new Node().parallelSynch(MessageProcessorNotificationTestCase.this.pre().serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post())).parallelSynch(MessageProcessorNotificationTestCase.this.post().serial(MessageProcessorNotificationTestCase.this.prePost())));
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://until-successful-with-processor-chain", (Object)"test", null));
        this.client.request("vm://out-us", 5000L);
        this.assertNotifications();
    }

    @Test
    public void untilSuccesfulWithEnricher() throws Exception {
        this.specificationFactory = new Factory(){

            public Object create() {
                return new Node().serial(MessageProcessorNotificationTestCase.this.pre()).serial(new Node().parallelSynch(MessageProcessorNotificationTestCase.this.pre().serial(MessageProcessorNotificationTestCase.this.prePost()).serial(MessageProcessorNotificationTestCase.this.post())).parallelSynch(MessageProcessorNotificationTestCase.this.post().serial(MessageProcessorNotificationTestCase.this.prePost())));
            }
        };
        Assert.assertNotNull((Object)this.client.send("vm://until-successful-with-enricher", (Object)"test", null));
        this.assertNotifications();
    }

    @Override
    public RestrictedNode getSpecification() {
        return (RestrictedNode)this.specificationFactory.create();
    }

    @Override
    public void validateSpecification(RestrictedNode spec) throws Exception {
    }
}

