/*
 * Decompiled with CFR 0.152.
 */
package org.mule.issues;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.MuleClient;
import org.mule.module.xml.functional.AbstractXmlFunctionalTestCase;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastRouterMule2136TestCase
extends AbstractXmlFunctionalTestCase {
    public static final int TEST_COUNT = 2000;
    public static final String SERIALIZED = "<org.mule.issues.MulticastRouterMule2136TestCase_-Parent>\n  <child/>\n</org.mule.issues.MulticastRouterMule2136TestCase_-Parent>";
    private static final Logger LOGGER = LoggerFactory.getLogger(MulticastRouterMule2136TestCase.class);

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/issues/multicast-router-mule-2136-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/issues/multicast-router-mule-2136-test-flow.xml"});
    }

    public MulticastRouterMule2136TestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected MuleClient sendObject() throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("object-in", (Object)new Parent(new Child()), null);
        return client;
    }

    @Test
    public void testObjectOut() throws MuleException, InterruptedException {
        this.request(this.sendObject(), "object-out", Parent.class);
        Thread.sleep(3000L);
    }

    @Test
    public void testObjectXmlOut() throws MuleException {
        String xml = (String)this.request(this.sendObject(), "object-xml-out", String.class);
        Assert.assertEquals((Object)SERIALIZED, (Object)xml);
    }

    @Test
    public void testXmlObjectOut() throws MuleException {
        this.request(this.sendObject(), "xml-object-out", Parent.class);
    }

    @Test
    public void testStress() throws MuleException {
        int tenth = 200;
        for (int i = 0; i < 2000; ++i) {
            this.testObjectXmlOut();
            this.request((MuleClient)muleContext.getClient(), "xml-object-out", Parent.class);
            if (i % tenth != 0) continue;
            LOGGER.info("Iteration " + i);
        }
    }

    protected Object request(MuleClient client, String endpoint, Class<?> clazz) throws MuleException {
        MuleMessage message = client.request(endpoint, 6000L);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getPayload());
        Class<?> payloadClass = message.getPayload().getClass();
        String assertionMessage = String.format("expected payload of type %1s but was %2s", clazz.getName(), payloadClass);
        Assert.assertTrue((String)assertionMessage, (boolean)clazz.isAssignableFrom(payloadClass));
        return message.getPayload();
    }

    public static class Child {
    }

    public static class Parent {
        private Child child;

        public Parent() {
            this(null);
        }

        public Parent(Child child) {
            this.setChild(child);
        }

        public Child getChild() {
            return this.child;
        }

        public void setChild(Child child) {
            this.child = child;
        }
    }
}

