/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.functional;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class JXPathTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "jxpath-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "jxpath-config-flow.xml"});
    }

    public JXPathTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testSetMessagePropertyFromXmlWithNamespacesDefinedWithSamePrefix() throws Exception {
        String xml = "<root xmlns:h=\"http://www.w3.org/TR/html4/\" xmlns:f=\"http://www.w3schools.com/furniture\"><h:table><h:tr><h:td>Apples</h:td><h:td>Bananas</h:td></h:tr></h:table><f:table><f:name>African Coffee Table</f:name><f:width>80</f:width><f:length>120</f:length></f:table></root>";
        this.doTest(xml);
    }

    @Test
    public void testSetMessagePropertyFromXmlWithNamespacesDefinedWithDifferentPrefix() throws Exception {
        String xml = "<root xmlns:h=\"http://www.w3.org/TR/html4/\" xmlns:z=\"http://www.w3schools.com/furniture\"><h:table><h:tr><h:td>Apples</h:td><h:td>Bananas</h:td></h:tr></h:table><z:table><z:name>African Coffee Table</z:name><z:width>80</z:width><z:length>120</z:length></z:table></root>";
        this.doTest(xml);
    }

    private void doTest(String xml) throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://in", (Object)xml, null);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getInboundProperty("nameProperty"));
        Assert.assertEquals((Object)"African Coffee Table", (Object)response.getInboundProperty("nameProperty"));
    }
}

