/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.security.CryptoFailureException;
import org.mule.api.security.EncryptionStrategyNotFoundException;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityProviderNotFoundException;
import org.mule.api.security.UnknownAuthenticationTypeException;
import org.mule.processor.SecurityFilterMessageProcessor;
import org.mule.security.AbstractAuthenticationFilter;
import org.mule.security.filters.MuleEncryptionEndpointSecurityFilter;
import org.mule.tck.junit4.FunctionalTestCase;

public class SecurityFilterTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/config/security-filter-config.xml";
    }

    @Test
    public void testConfig() throws Exception {
        EndpointBuilder epb = muleContext.getRegistry().lookupEndpointBuilder("testEndpoint1");
        Assert.assertNotNull((Object)epb);
        InboundEndpoint iep = epb.buildInboundEndpoint();
        List mps = iep.getMessageProcessors();
        int count = 0;
        SecurityFilterMessageProcessor securityMp = null;
        for (MessageProcessor mp : mps) {
            if (!(mp instanceof SecurityFilterMessageProcessor)) continue;
            ++count;
            securityMp = (SecurityFilterMessageProcessor)mp;
        }
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertEquals(CustomSecurityFilter.class, securityMp.getFilter().getClass());
        epb = muleContext.getRegistry().lookupEndpointBuilder("testEndpoint2");
        Assert.assertNotNull((Object)epb);
        iep = epb.buildInboundEndpoint();
        mps = iep.getMessageProcessors();
        count = 0;
        securityMp = null;
        for (MessageProcessor mp : mps) {
            if (!(mp instanceof SecurityFilterMessageProcessor)) continue;
            ++count;
            securityMp = (SecurityFilterMessageProcessor)mp;
        }
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertEquals(MuleEncryptionEndpointSecurityFilter.class, securityMp.getFilter().getClass());
    }

    public static class CustomSecurityFilter
    extends AbstractAuthenticationFilter {
        protected void doInitialise() throws InitialisationException {
        }

        public void authenticate(MuleEvent event) throws SecurityException, UnknownAuthenticationTypeException, CryptoFailureException, SecurityProviderNotFoundException, EncryptionStrategyNotFoundException, InitialisationException {
        }
    }
}

