/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.processor.DynamicPipelineException;
import org.mule.api.processor.MessageProcessor;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transformer.simple.ParseTemplateTransformer;
import org.mule.transformer.simple.StringAppendTransformer;

public class DynamicFlowTestCase
extends FunctionalTestCase {
    private MuleClient client;

    protected String getConfigFile() {
        return "org/mule/test/construct/dynamic-flow.xml";
    }

    @Before
    public void before() {
        this.client = muleContext.getClient();
    }

    @Test
    public void addPreMessageProccesor() throws Exception {
        MuleMessage result = this.client.send("vm://dynamic", (Object)"source->", null);
        Assert.assertEquals((Object)"source->(static)", (Object)result.getPayloadAsString());
        Flow flow = DynamicFlowTestCase.getFlow("dynamicFlow");
        String pipelineId = flow.dynamicPipeline(null).injectBefore(new MessageProcessor[]{new StringAppendTransformer("(pre)")}).resetAndUpdate();
        result = this.client.send("vm://dynamic", (Object)"source->", null);
        Assert.assertEquals((Object)"source->(pre)(static)", (Object)result.getPayloadAsString());
        flow.dynamicPipeline(pipelineId).injectBefore(new MessageProcessor[]{new StringAppendTransformer("(pre1)"), new StringAppendTransformer("(pre2)")}).resetAndUpdate();
        result = this.client.send("vm://dynamic", (Object)"source->", null);
        Assert.assertEquals((Object)"source->(pre1)(pre2)(static)", (Object)result.getPayloadAsString());
    }

    @Test
    public void addPrePostMessageProccesor() throws Exception {
        Flow flow = DynamicFlowTestCase.getFlow("dynamicFlow");
        String pipelineId = flow.dynamicPipeline(null).injectBefore(new MessageProcessor[]{new StringAppendTransformer("(pre)")}).injectAfter(new MessageProcessor[]{new StringAppendTransformer("(post)")}).resetAndUpdate();
        MuleMessage result = this.client.send("vm://dynamic", (Object)"source->", null);
        Assert.assertEquals((Object)"source->(pre)(static)(post)", (Object)result.getPayloadAsString());
        flow.dynamicPipeline(pipelineId).injectBefore(new MessageProcessor[]{new StringAppendTransformer("(pre)")}).injectAfter(new MessageProcessor[]{new StringAppendTransformer("(post1)"), new StringAppendTransformer("(post2)")}).resetAndUpdate();
        result = this.client.send("vm://dynamic", (Object)"source->", null);
        Assert.assertEquals((Object)"source->(pre)(static)(post1)(post2)", (Object)result.getPayloadAsString());
    }

    @Test
    public void dynamicComponent() throws Exception {
        MuleMessage result = this.client.send("vm://dynamicComponent", (Object)"source->", null);
        Assert.assertEquals((Object)"source->(static)", (Object)result.getPayloadAsString());
        result = this.client.send("vm://dynamicComponent", (Object)"source->", null);
        Assert.assertEquals((Object)"source->chain update #1(static)", (Object)result.getPayloadAsString());
        result = this.client.send("vm://dynamicComponent", (Object)"source->", null);
        Assert.assertEquals((Object)"source->chain update #2(static)", (Object)result.getPayloadAsString());
    }

    @Test
    public void exceptionOnInjectedMessageProcessor() throws Exception {
        ArrayList<Object> preList = new ArrayList<Object>();
        ArrayList<StringAppendTransformer> postList = new ArrayList<StringAppendTransformer>();
        Flow flow = DynamicFlowTestCase.getFlow("exceptionFlow");
        preList.add(new StringAppendTransformer("(pre)"));
        preList.add(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                throw new RuntimeException("force exception!");
            }
        });
        postList.add(new StringAppendTransformer("(post)"));
        flow.dynamicPipeline(null).injectBefore(preList).injectAfter(postList).resetAndUpdate();
        MuleMessage result = this.client.send("vm://exception", (Object)"source->", null);
        Assert.assertEquals((Object)"source->(pre)(handled)", (Object)result.getPayloadAsString());
    }

    @Test
    public void proposeInitialPipelineIdSucceeds() throws Exception {
        String proposedId = "valid-id";
        String pipelineId = DynamicFlowTestCase.getFlow("dynamicFlow").dynamicPipeline(proposedId).resetAndUpdate();
        Assert.assertEquals((Object)pipelineId, (Object)proposedId);
    }

    @Test
    public void dynamicPipelineCanBeUpdatedAfterFailure() throws Exception {
        String proposedId = "ID";
        Flow flow = DynamicFlowTestCase.getFlow("dynamicFlow");
        try {
            ParseTemplateTransformer invalidProcessor = new ParseTemplateTransformer();
            flow.dynamicPipeline(proposedId).injectBefore(new MessageProcessor[]{invalidProcessor}).resetAndUpdate();
        }
        catch (MuleException invalidProcessor) {
            // empty catch block
        }
        flow.dynamicPipeline(proposedId).injectBefore(new MessageProcessor[]{new StringAppendTransformer("(pre)")}).injectAfter(new MessageProcessor[]{new StringAppendTransformer("(post)")}).resetAndUpdate();
        MuleMessage result = this.client.send("vm://dynamic", (Object)"source->", null);
        Assert.assertEquals((Object)"source->(pre)(static)(post)", (Object)result.getPayloadAsString());
    }

    @Test
    public void applyLifecycle() throws Exception {
        StringBuilder expected = new StringBuilder();
        Flow flow = DynamicFlowTestCase.getFlow("dynamicFlow");
        LifecycleMessageProcessor lifecycleMessageProcessor = new LifecycleMessageProcessor();
        String pipelineId = flow.dynamicPipeline(null).injectBefore(new MessageProcessor[]{lifecycleMessageProcessor}).resetAndUpdate();
        MuleMessage result = this.client.send("vm://dynamic", (Object)"source->", null);
        Assert.assertEquals((Object)"source->(pre)(static)", (Object)result.getPayloadAsString());
        Assert.assertEquals((Object)expected.append("ISP").toString(), (Object)lifecycleMessageProcessor.getSteps());
        result = this.client.send("vm://dynamic", (Object)"source->", null);
        Assert.assertEquals((Object)"source->(pre)(static)", (Object)result.getPayloadAsString());
        Assert.assertEquals((Object)expected.append("P").toString(), (Object)lifecycleMessageProcessor.getSteps());
        flow.dynamicPipeline(pipelineId).reset();
        Assert.assertEquals((Object)expected.append("TD").toString(), (Object)lifecycleMessageProcessor.getSteps());
        result = this.client.send("vm://dynamic", (Object)"source->", null);
        Assert.assertEquals((Object)"source->(static)", (Object)result.getPayloadAsString());
        Assert.assertEquals((Object)expected.toString(), (Object)lifecycleMessageProcessor.getSteps());
    }

    @Test
    public void applyAwareInterfaces() throws Exception {
        Flow flow = DynamicFlowTestCase.getFlow("dynamicFlow");
        UberAwareMessageProcessor awareMessageProcessor = new UberAwareMessageProcessor();
        flow.dynamicPipeline(null).injectBefore(new MessageProcessor[]{awareMessageProcessor}).resetAndUpdate();
        MuleMessage result = this.client.send("vm://dynamic", (Object)"source->", null);
        Assert.assertEquals((Object)"source->(pre)(static)", (Object)result.getPayloadAsString());
        Assert.assertNotNull((Object)awareMessageProcessor.getFlowConstruct());
        Assert.assertNotNull((Object)awareMessageProcessor.getMuleContext());
    }

    @Test(expected=DynamicPipelineException.class)
    public void invalidNullPipelineId() throws Exception {
        DynamicFlowTestCase.getFlow("dynamicFlow").dynamicPipeline(null).resetAndUpdate();
        DynamicFlowTestCase.getFlow("dynamicFlow").dynamicPipeline(null).reset();
    }

    @Test(expected=DynamicPipelineException.class)
    public void invalidPipelineId() throws Exception {
        String id = DynamicFlowTestCase.getFlow("dynamicFlow").dynamicPipeline(null).resetAndUpdate();
        DynamicFlowTestCase.getFlow("dynamicFlow").dynamicPipeline(id + "x").reset();
    }

    private static Flow getFlow(String flowName) throws MuleException {
        return (Flow)muleContext.getRegistry().lookupFlowConstruct(flowName);
    }

    private static class UberAwareMessageProcessor
    implements MessageProcessor,
    MuleContextAware,
    FlowConstructAware {
        private FlowConstruct flowConstruct;
        private MuleContext muleContext;

        private UberAwareMessageProcessor() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            event.getMessage().setPayload((Object)(event.getMessage().getPayload() + "(pre)"));
            return event;
        }

        public void setFlowConstruct(FlowConstruct flowConstruct) {
            this.flowConstruct = flowConstruct;
        }

        public void setMuleContext(MuleContext muleContext) {
            this.muleContext = muleContext;
        }

        public FlowConstruct getFlowConstruct() {
            return this.flowConstruct;
        }

        public MuleContext getMuleContext() {
            return this.muleContext;
        }
    }

    private static class LifecycleMessageProcessor
    implements MessageProcessor,
    Lifecycle {
        private StringBuffer steps = new StringBuffer();

        private LifecycleMessageProcessor() {
        }

        public void dispose() {
            this.steps.append("D");
        }

        public void initialise() throws InitialisationException {
            this.steps.append("I");
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.steps.append("P");
            event.getMessage().setPayload((Object)(event.getMessage().getPayload() + "(pre)"));
            return event;
        }

        public void start() throws MuleException {
            this.steps.append("S");
        }

        public void stop() throws MuleException {
            this.steps.append("T");
        }

        public String getSteps() {
            return this.steps.toString();
        }
    }

    public static class Component
    implements Callable {
        private String pipelineId;
        private int count;

        public Object onCall(MuleEventContext eventContext) throws Exception {
            Flow flow = (Flow)eventContext.getMuleContext().getRegistry().lookupFlowConstruct("dynamicComponentFlow");
            this.pipelineId = flow.dynamicPipeline(this.pipelineId).injectBefore(new MessageProcessor[]{new StringAppendTransformer("chain update #" + ++this.count)}).resetAndUpdate();
            return eventContext.getMessage();
        }
    }
}

