/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Orange;

public class FlowNestingTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "org/mule/test/construct/flow-nesting-config.xml";
    }

    @Test
    public void testNestingFiltersAccepted() throws MuleException {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)new Orange(), muleContext);
        request.setOutboundProperty("Currency", (Object)"MyCurrency");
        request.setOutboundProperty("AcquirerCountry", (Object)"MyCountry");
        request.setOutboundProperty("Amount", (Object)"4999");
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://inFilter", (MuleMessage)request);
        MuleMessage result = client.request("vm://outFilter", 5000L);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testNestingFiltersRejected() throws MuleException {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)new Apple(), muleContext);
        request.setOutboundProperty("Currency", (Object)"MyCurrency");
        request.setOutboundProperty("AcquirerCountry", (Object)"MyCountry");
        request.setOutboundProperty("Amount", (Object)"4999");
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://inFilter", (MuleMessage)request);
        MuleMessage result = client.request("vm://outFilter", 5000L);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testNestingChoiceAccepted() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)new Apple(), muleContext);
        request.setOutboundProperty("AcquirerCountry", (Object)"MyCountry");
        request.setOutboundProperty("Amount", (Object)"4999");
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://inChoice", (MuleMessage)request);
        MuleMessage result = client.request("vm://outChoice", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"ABC", (Object)result.getPayloadAsString());
    }

    @Test
    public void testNestingChoiceRejected() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)new Apple(), muleContext);
        request.setOutboundProperty("AcquirerCountry", (Object)"MyCountry");
        request.setOutboundProperty("Amount", (Object)"5000");
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://inChoice", (MuleMessage)request);
        MuleMessage result = client.request("vm://outChoice", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"AB", (Object)result.getPayloadAsString());
    }
}

