/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.NullPayload;
import org.mule.util.IOUtils;

public class FlowUseCaseProcessingStrategyTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "org/mule/test/construct/flow-usecase-processing-strategy-config.xml";
    }

    @Test
    public void testHTTPStatusCodeExceptionSyncStrategy() throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        HttpRequestOptions httpRequestOptions = HttpRequestOptionsBuilder.newOptions().disableStatusCodeValidation().build();
        MuleMessage exception = client.send("http://localhost:" + this.dynamicPort.getNumber(), FlowUseCaseProcessingStrategyTestCase.getTestMuleMessage((Object)NullPayload.getInstance()), (OperationOptions)httpRequestOptions);
        Assert.assertThat((Object)exception.getInboundProperty("http.status", (Object)0), (Matcher)Matchers.is((Object)500));
    }

    @Test
    public void testFileAutoDeleteSyncStrategy() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        File tempFile = this.createTempFile("mule-file-test-sync-");
        client.request("vm://exception", 5000L);
        Assert.assertTrue((boolean)tempFile.exists());
    }

    @Test
    public void testFileAutoDeleteAsyncStrategy() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        File tempFile = this.createTempFile("mule-file-test-async-");
        client.request("vm://exception", 5000L);
        Assert.assertFalse((boolean)tempFile.exists());
    }

    private File createTempFile(String fileName) throws IOException {
        File directory = this.getWorkingDirectory();
        File file = File.createTempFile(fileName, ".txt", directory);
        file.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(file);
        IOUtils.write((String)"The quick brown fox jumps over the lazy dog", (OutputStream)fos);
        IOUtils.closeQuietly((OutputStream)fos);
        return file;
    }
}

