/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.client;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.lifecycle.Callable;
import org.mule.api.processor.MessageProcessor;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.concurrent.Latch;

public class MuleClientDispatchExceptionHandlingTestCase
extends FunctionalTestCase {
    private static final Log logger = LogFactory.getLog(MuleClientDispatchExceptionHandlingTestCase.class);
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    private static Latch innerFlowLatch;
    private static Latch exceptionLatch;
    private static MuleEvent eventFromMainFlow;
    private static MuleMessage messageFromMainFlow;
    private static boolean eventPropagated;
    private static boolean isSameMessage;

    protected String getConfigFile() {
        return "org/mule/test/integration/client/client-dispatch-catch-exception-flow.xml";
    }

    @Test
    public void testCatchExceptionThrowFromJavaComponentToJavaComponent() throws Exception {
        this.doSendMessageToEndpoint("vm://catchExceptionJavaComponentToJavaComponent");
    }

    @Test
    public void tesCatchExceptionThrowFromJavaComponentToMessageProcessor() throws Exception {
        this.doSendMessageToEndpoint("vm://catchExceptionJavaComponentToMessageProcessor");
    }

    @Test
    public void testCatchExceptionThrowFromMessageProcessorToJavaComponent() throws Exception {
        this.doSendMessageToEndpoint("vm://catchExceptionMessageProcessorToJavaComponent");
    }

    @Test
    public void tesCatchExceptionThrowFromMessageProcessorToMessageProcessor() throws Exception {
        this.doSendMessageToEndpoint("vm://catchExceptionMessageProcessorToMessageProcessor");
    }

    @Test
    public void testCatchExceptionJavaComponentToJavaComponentRequestResponseInnerFlow() throws Exception {
        this.doSendMessageToEndpoint("vm://catchExceptionJavaComponentToJavaComponentRequestResponseInnerFlow");
    }

    private void doSendMessageToEndpoint(String endpoint) throws Exception {
        innerFlowLatch = new Latch();
        exceptionLatch = new Latch();
        eventPropagated = true;
        isSameMessage = true;
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send(endpoint, MuleClientDispatchExceptionHandlingTestCase.getTestMuleMessage((Object)"Original Message"));
        boolean innerFlowCalled = innerFlowLatch.await(3L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)innerFlowCalled, (Matcher)Is.is((Object)true));
        boolean exceptionHandled = exceptionLatch.await(3L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)exceptionHandled, (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)isSameMessage, (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)eventPropagated, (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue(MuleMessage.class));
    }

    public static class InnerFlowCountDownProcessor
    implements MessageProcessor {
        public synchronized MuleEvent process(MuleEvent event) throws MuleException {
            innerFlowLatch.countDown();
            return event;
        }
    }

    public static class ExecutionCountDownProcessor
    implements MessageProcessor {
        public synchronized MuleEvent process(MuleEvent event) throws MuleException {
            exceptionLatch.countDown();
            return event;
        }
    }

    public static class DispatchInnerFlowThrowExceptionMessageProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            eventFromMainFlow = RequestContext.getEvent();
            messageFromMainFlow = eventFromMainFlow.getMessage();
            event.getMuleContext().getClient().dispatch("vm://vminnertest", (MuleMessage)new DefaultMuleMessage((Object)"payload", event.getMuleContext()));
            throw new DefaultMuleException("expected exception!");
        }
    }

    public static class SendInnerFlowThrowExceptionJavaComponent
    implements Callable {
        public Object onCall(MuleEventContext eventContext) throws Exception {
            eventFromMainFlow = RequestContext.getEvent();
            messageFromMainFlow = eventFromMainFlow.getMessage();
            eventContext.sendEvent((MuleMessage)new DefaultMuleMessage((Object)"payload", eventContext.getMuleContext()), "vm://vminnerrequestresponsetest");
            throw new Exception("expected exception!");
        }
    }

    public static class DispatchInnerFlowThrowExceptionJavaComponent
    implements Callable {
        public Object onCall(MuleEventContext eventContext) throws Exception {
            eventFromMainFlow = RequestContext.getEvent();
            messageFromMainFlow = eventFromMainFlow.getMessage();
            eventContext.dispatchEvent((MuleMessage)new DefaultMuleMessage((Object)"payload", eventContext.getMuleContext()), "vm://vminnertest");
            throw new Exception("expected exception!");
        }
    }

    public static class AssertEventProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            isSameMessage = RequestContext.getEvent().getMessage().equals(messageFromMainFlow);
            return event;
        }
    }

    public static class AssertEventComponent
    implements Callable {
        public Object onCall(MuleEventContext eventContext) throws Exception {
            isSameMessage = RequestContext.getEvent().getMessage().equals(messageFromMainFlow);
            return eventContext.getMessage();
        }
    }
}

