/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.client;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.lifecycle.Callable;
import org.mule.api.processor.MessageProcessor;
import org.mule.tck.functional.FlowAssert;
import org.mule.tck.junit4.FunctionalTestCase;

public class MuleClientDispatchWithoutLosingVariablesTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/client/client-flow-session-vars-when-dispatch-flow.xml";
    }

    private void doSendMessageToVMEndpoint(String flowName) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://" + flowName, (Object)"TEST1", null);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue(MuleMessage.class));
        FlowAssert.verify((String)flowName);
    }

    @Test
    public void testFlowVarsAfterDispatchFromMessageProcessor() throws Exception {
        this.doSendMessageToVMEndpoint("flowVarsFlowUsingProcessor");
    }

    @Test
    public void testSessionVarsAfterDispatchFromMessageProcessor() throws Exception {
        this.doSendMessageToVMEndpoint("sessionVarsFlowUsingProcessor");
    }

    @Test
    public void testFlowVarsAfterDispatchFromJavaComponent() throws Exception {
        this.doSendMessageToVMEndpoint("flowVarsFlowUsingJavaComponent");
    }

    @Test
    public void testSessionVarsAfterDispatchFromJavaComponent() throws Exception {
        this.doSendMessageToVMEndpoint("sessionVarsFlowUsingJavaComponent");
    }

    @Test
    public void testSessionVarsFlowUsingJavaComponentRequestResponse() throws Exception {
        this.doSendMessageToVMEndpoint("sessionVarsFlowUsingJavaComponentRequestResponse");
    }

    public static class JavaComponentSendFlowUsingNewMuleClient
    implements Callable {
        public Object onCall(MuleEventContext eventContext) throws Exception {
            eventContext.sendEvent((MuleMessage)new DefaultMuleMessage((Object)"payload", eventContext.getMuleContext()), "vm://vminnerrequestresponsetest");
            return eventContext.getMessage();
        }
    }

    public static class JavaComponentDispatchFlowUsingNewMuleClient
    implements Callable {
        public Object onCall(MuleEventContext eventContext) throws Exception {
            eventContext.dispatchEvent((MuleMessage)new DefaultMuleMessage((Object)"payload", eventContext.getMuleContext()), "vm://vminnertest");
            return eventContext.getMessage();
        }
    }

    public static class MessageProcessorDispatchFlowUsingNewMuleClient
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            event.getMuleContext().getClient().dispatch("vm://vminnertest", (MuleMessage)new DefaultMuleMessage((Object)"payload", event.getMuleContext()));
            return event;
        }
    }
}

