/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.components;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.client.LocalMuleClient;
import org.mule.lifecycle.JSR250LifecycleTrackerComponent;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.NullPayload;

public class JSR250LifecycleTrackerComponentFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/components/jsr250-component-lifecycle-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/components/jsr250-component-lifecycle-config-flow.xml"});
    }

    public JSR250LifecycleTrackerComponentFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testSingletonServiceLifecycle() throws Exception {
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW)) {
            this.testComponentLifecycle("MuleSingletonService", "[setProperty, setMuleContext, jsr250 initialise, start, stop, jsr250 dispose]");
        } else {
            this.testComponentLifecycle("MuleSingletonService", "[setProperty, setService, setMuleContext, jsr250 initialise, start, stop, jsr250 dispose]");
        }
    }

    @Test
    public void testMulePrototypeServiceLifecycle() throws Exception {
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW)) {
            this.testComponentLifecycle("MulePrototypeService", "[setProperty, setMuleContext, jsr250 initialise, start, stop, jsr250 dispose]");
        } else {
            this.testComponentLifecycle("MulePrototypeService", "[setProperty, setService, setMuleContext, jsr250 initialise, start, stop, jsr250 dispose]");
        }
    }

    @Test
    public void testMulePooledPrototypeServiceLifecycle() throws Exception {
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW)) {
            this.testComponentLifecycle("MulePooledPrototypeService", "[setProperty, setMuleContext, jsr250 initialise, start, stop, jsr250 dispose]");
        } else {
            this.testComponentLifecycle("MulePooledPrototypeService", "[setProperty, setService, setMuleContext, jsr250 initialise, start, stop, jsr250 dispose]");
        }
    }

    @Test
    public void testMulePooledSingletonServiceLifecycle() throws Exception {
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW)) {
            this.testComponentLifecycle("MulePooledSingletonService", "[setProperty, setMuleContext, jsr250 initialise, jsr250 initialise, jsr250 initialise, start, start, start, stop, stop, stop, jsr250 dispose, jsr250 dispose, jsr250 dispose]");
        } else {
            this.testComponentLifecycle("MulePooledSingletonService", "[setProperty, setService, setMuleContext, jsr250 initialise, jsr250 initialise, jsr250 initialise, start, start, start, stop, stop, stop, jsr250 dispose, jsr250 dispose, jsr250 dispose]");
        }
    }

    private void testComponentLifecycle(String serviceName, String expectedLifeCycle) throws Exception {
        JSR250LifecycleTrackerComponent tracker = this.exerciseComponent(serviceName);
        muleContext.dispose();
        Assert.assertEquals((String)serviceName, (Object)expectedLifeCycle, (Object)tracker.getTracker().toString());
    }

    private JSR250LifecycleTrackerComponent exerciseComponent(String serviceName) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        JSR250LifecycleTrackerComponent ltc = (JSR250LifecycleTrackerComponent)client.send("vm://" + serviceName + ".In", JSR250LifecycleTrackerComponentFunctionalTestCase.getTestMuleMessage((Object)NullPayload.getInstance())).getPayload();
        Assert.assertNotNull((Object)ltc);
        return ltc;
    }
}

