/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.construct;

import java.util.Arrays;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.cache.CachingStrategy;
import org.mule.api.processor.MessageProcessor;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.test.integration.construct.HttpProxyTestCase;

public class CachedHttpProxyTestCase
extends HttpProxyTestCase {
    private static boolean invokedCache;

    public CachedHttpProxyTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/construct/cached-http-proxy-config.xml"}});
    }

    @Before
    public void setUp() throws Exception {
        invokedCache = false;
    }

    @After
    public void tearDown() throws Exception {
        Assert.assertTrue((String)"Cache was never invoked", (boolean)invokedCache);
    }

    public static class TestCachingStrategy
    implements CachingStrategy {
        public MuleEvent process(MuleEvent request, MessageProcessor messageProcessor) throws MuleException {
            invokedCache = true;
            return messageProcessor.process(request);
        }
    }
}

