/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.classloader;

import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.rule.UseMuleLog4jContextFactory;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.listener.Callback;
import org.mule.tck.listener.FlowExecutionListener;
import org.mule.test.infrastructure.deployment.AbstractFakeMuleServerTestCase;
import org.mule.test.infrastructure.deployment.FakeMuleServer;

public class ConnectorLevelMessageDispatchingTestCase
extends AbstractFakeMuleServerTestCase {
    public static final String HELLO_WORLD_APP = "hello-world";
    public static final String HELLO_MULE_APP = "hello-mule";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    @Rule
    public SystemProperty endpointScheme = new SystemProperty("scheme", "http");
    @Rule
    public UseMuleLog4jContextFactory muleLogging = new UseMuleLog4jContextFactory();

    @Test
    public void verifyClassLoaderIsAppClassLoader() throws Exception {
        this.muleServer.deployDomainFromClasspathFolder("domain/deployable-domains/http-connector-domain", "domain");
        this.muleServer.deployAppFromClasspathFolder("domain/deployable-apps/hello-world-app", HELLO_WORLD_APP);
        this.muleServer.deployAppFromClasspathFolder("domain/deployable-apps/hello-mule-app", HELLO_MULE_APP);
        this.muleServer.start();
        this.verifyAppProcessMessageWithAppClassLoader(this.muleServer, HELLO_MULE_APP, "http://localhost:%d/service/helloMule");
        this.verifyAppProcessMessageWithAppClassLoader(this.muleServer, HELLO_WORLD_APP, "http://localhost:%d/service/helloWorld");
    }

    private void verifyAppProcessMessageWithAppClassLoader(FakeMuleServer fakeMuleServer, String appName, String requestUrl) throws MuleException {
        MuleContext applicationContext = fakeMuleServer.findApplication(appName).getMuleContext();
        final AtomicReference executionClassLoader = new AtomicReference();
        FlowExecutionListener flowExecutionListener = new FlowExecutionListener(applicationContext);
        flowExecutionListener.addListener((Callback)new Callback<MuleEvent>(){

            public void execute(MuleEvent source) {
                executionClassLoader.set(Thread.currentThread().getContextClassLoader());
            }
        });
        applicationContext.getClient().send(String.format(requestUrl, this.dynamicPort.getNumber()), (Object)"test-data", null);
        flowExecutionListener.waitUntilFlowIsComplete();
        Assert.assertThat(executionClassLoader.get(), (Matcher)Is.is((Object)applicationContext.getExecutionClassLoader()));
    }
}

