/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.tls;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class TlsCustomTruststoreTestCase
extends FunctionalTestCase {
    private static final String RESPONSE = "test";
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public DynamicPort portSsl = new DynamicPort("portSsl");
    @Rule
    public SystemProperty customTrustStoreEnabled = new SystemProperty("javax.net.ssl.trustStore", "src/test/resources/chain-cert-truststore.jks");

    protected String getConfigFile() {
        return "tls/tls-clustom-truststore-config.xml";
    }

    @Test
    public void usingCustomTlsTrustManager() throws Exception {
        MuleMessage message = this.runFlow("flow-custom").getMessage();
        MatcherAssert.assertThat((Object)RESPONSE, (Matcher)CoreMatchers.equalTo((Object)message.getPayloadAsString()));
    }

    @Test
    public void usingDefaultTlsTrustManager() throws Exception {
        MuleMessage message = this.runFlow("flow-default").getMessage();
        MatcherAssert.assertThat((Object)RESPONSE, (Matcher)CoreMatchers.equalTo((Object)message.getPayloadAsString()));
    }
}

