/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.tls;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.construct.Flow;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.module.http.api.requester.HttpRequesterConfig;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.DomainFunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.ssl.api.TlsContextFactory;

public class TlsSharedContextTestCase
extends DomainFunctionalTestCase {
    private static final String DATA = "data";
    private static final String FIRST_APP = "firstApp";
    private static final String SECOND_APP = "secondApp";
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    @Rule
    public DynamicPort port2 = new DynamicPort("port2");
    @Rule
    public DynamicPort port3 = new DynamicPort("port3");

    protected String getDomainConfig() {
        return "domain/tls/tls-domain-config.xml";
    }

    public DomainFunctionalTestCase.ApplicationConfig[] getConfigResources() {
        return new DomainFunctionalTestCase.ApplicationConfig[]{new DomainFunctionalTestCase.ApplicationConfig((DomainFunctionalTestCase)this, FIRST_APP, new String[]{"domain/tls/tls-first-app-config.xml"}), new DomainFunctionalTestCase.ApplicationConfig((DomainFunctionalTestCase)this, SECOND_APP, new String[]{"domain/tls/tls-second-app-config.xml"})};
    }

    @Test
    public void sharedRequesterUsingSharedTlsContextToLocalListener() throws Exception {
        this.testFlowForApp("helloWorldClientFlow", FIRST_APP, "hello world");
    }

    @Test
    public void localRequesterToSharedListenerUsingSharedTlsContext() throws Exception {
        this.testFlowForApp("helloMuleClientFlow", SECOND_APP, "hello mule");
    }

    @Test
    public void muleClientUsingLocalRequesterWithSharedTlsContextToListenerUsingSharedTlsContext() throws Exception {
        MuleContext secondAppContext = this.getMuleContextForApp(SECOND_APP);
        HttpRequesterConfig requesterConfig = (HttpRequesterConfig)secondAppContext.getRegistry().lookupObject("requestConfig");
        HttpRequestOptions requestConfigOptions = HttpRequestOptionsBuilder.newOptions().requestConfig(requesterConfig).build();
        this.testMuleClient(requestConfigOptions);
    }

    @Test
    public void muleClientUsingSharedTlsContextToListenerUsingSharedTlsContext() throws Exception {
        MuleContext domainContext = this.getMuleContextForDomain();
        TlsContextFactory tlsContextFactory = (TlsContextFactory)domainContext.getRegistry().lookupObject("sharedTlsContext2");
        HttpRequestOptions tlsContextOptions = HttpRequestOptionsBuilder.newOptions().tlsContextFactory(tlsContextFactory).build();
        this.testMuleClient(tlsContextOptions);
    }

    private void testMuleClient(HttpRequestOptions operationOptions) throws Exception {
        MuleContext context = this.getMuleContextForApp(SECOND_APP);
        MuleMessage response = context.getClient().send(String.format("https://localhost:%s/helloAll", this.port3.getValue()), (MuleMessage)new DefaultMuleMessage((Object)DATA, context), (OperationOptions)operationOptions);
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Matchers.is((Object)"hello all"));
    }

    private void testFlowForApp(String flowName, String appName, String expected) throws Exception {
        MuleContext appContext = this.getMuleContextForApp(appName);
        Flow helloWorldFlow = (Flow)appContext.getRegistry().lookupFlowConstruct(flowName);
        MuleEvent response = helloWorldFlow.process(MuleTestUtils.getTestEvent((Object)DATA, (MessageExchangePattern)MessageExchangePattern.REQUEST_RESPONSE, (MuleContext)appContext));
        Assert.assertThat((Object)response.getMessage().getPayloadAsString(), (Matcher)Matchers.is((Object)expected));
    }
}

