/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.message.ExceptionMessage;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class DLQExceptionHandlerTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/exceptions/exception-dlq-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/exceptions/exception-dlq-flow.xml"});
    }

    public DLQExceptionHandlerTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testDLQ() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("jms://request.queue", (Object)"testing 1 2 3", null);
        MuleMessage message = client.request("jms://out.queue", 3000L);
        Assert.assertNull((Object)message);
        try {
            message = client.request("jms://DLQ", 20000L);
        }
        catch (MuleException e) {
            e.printStackTrace(System.err);
        }
        Assert.assertNotNull((Object)message);
        ExceptionMessage em = (ExceptionMessage)message.getPayload();
        Assert.assertEquals((Object)"testing 1 2 3", (Object)em.getPayload());
    }
}

