/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.NoReceiverForEndpointException;
import org.mule.exception.AbstractMessagingExceptionStrategy;
import org.mule.message.ExceptionMessage;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.NullPayload;
import org.mule.transport.email.FixedPortGreenMailSupport;
import org.mule.util.concurrent.Latch;

public class ExceptionStrategyCommonScenariosTestCase
extends AbstractServiceAndFlowTestCase {
    public static final String MESSAGE_TO_SEND = "A message";
    public static final String MESSAGE_MODIFIED = "A message with some text added";
    public static final int TIMEOUT = 5000;
    private static final Latch endMessageProcessorExecuted = new Latch();
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");
    @Rule
    public DynamicPort dynamicPort3 = new DynamicPort("port3");
    @Rule
    public DynamicPort dynamicPort4 = new DynamicPort("port4");
    @Rule
    public DynamicPort dynamicPort5 = new DynamicPort("port5");
    @Rule
    public DynamicPort dynamicPort6 = new DynamicPort("port6");
    @Rule
    public DynamicPort dynamicPort7 = new DynamicPort("port7");

    public ExceptionStrategyCommonScenariosTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/exceptions/exception-strategy-common-scenarios-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/exceptions/exception-strategy-common-scenarios-flow.xml"});
    }

    @Test
    public void testRoutePayloadBeforeException() throws Exception {
        final Latch messageProcessedLatch = new Latch();
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("LastMessageStateRouting");
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                messageProcessedLatch.release();
                throw new RuntimeException();
            }
        });
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("jms://in1?connector=jmsConnector", (Object)MESSAGE_TO_SEND, null);
        if (!messageProcessedLatch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Message never received by mule");
        }
        MuleMessage response = client.request("jms://dead.letter1?connector=jmsConnector", 5000L);
        Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)MESSAGE_MODIFIED));
    }

    @Test
    public void testRouteOriginalPayload() throws Exception {
        final Latch messageProcessedLatch = new Latch();
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("OriginalMessageRouting");
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                messageProcessedLatch.release();
                throw new RuntimeException();
            }
        });
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("jms://in2?connector=jmsConnector", (Object)MESSAGE_TO_SEND, null);
        if (!messageProcessedLatch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Message never received by mule");
        }
        MuleMessage response = client.request("jms://dead.letter2?connector=jmsConnector", 5000L);
        Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)MESSAGE_TO_SEND));
    }

    @Test
    public void testRouteByExceptionType() throws Exception {
        final CountDownLatch messageProcessedLatch = new CountDownLatch(3);
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("RouteByExceptionType");
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                messageProcessedLatch.countDown();
                throw new RuntimeException();
            }
        });
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("jms://in3?connector=jmsConnector", (Object)MESSAGE_TO_SEND, null);
        if (!messageProcessedLatch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Message never received by mule");
        }
        MuleMessage response = client.request("jms://dead.letter3?connector=jmsConnector", 5000L);
        Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)MESSAGE_TO_SEND));
        Assert.assertThat((Object)client.request("jms://exceptions?connector=jmsConnector", 5000L), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)client.request("jms://exceptions?connector=jmsConnector", 5000L), (Matcher)IsNull.notNullValue());
        MuleMessage exceptionResponse = client.request("jms://exceptions?connector=jmsConnector", 5000L);
        Assert.assertThat((Object)exceptionResponse, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)exceptionResponse.getPayload(), (Matcher)IsInstanceOf.instanceOf(ExceptionMessage.class));
    }

    @Test
    public void testPreservePayloadExceptionStrategy() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://in4", (Object)MESSAGE_TO_SEND, null, 5000L);
        Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)MESSAGE_MODIFIED));
    }

    @Test(expected=NoReceiverForEndpointException.class)
    public void testStopFlowBasedOnExceptionType() throws Throwable {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://in5", (Object)MESSAGE_TO_SEND, null, 5000L);
        Assert.assertThat((Object)((NullPayload)response.getPayload()), (Matcher)Is.is((Object)NullPayload.getInstance()));
        Assert.assertThat((Object)response.getExceptionPayload(), (Matcher)IsNull.notNullValue());
        try {
            client.send("vm://in5", (Object)MESSAGE_TO_SEND, null, 5000L);
        }
        catch (Exception e) {
            throw e.getCause();
        }
    }

    @Test
    public void testRollbackTransactionAndSendAnEmail() throws Exception {
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE)) {
            return;
        }
        FixedPortGreenMailSupport greenMailSupport = new FixedPortGreenMailSupport(this.dynamicPort2.getNumber());
        ArrayList<Integer> ports = new ArrayList<Integer>(6);
        ports.add(this.dynamicPort1.getNumber());
        ports.add(this.dynamicPort2.getNumber());
        ports.add(this.dynamicPort3.getNumber());
        ports.add(this.dynamicPort4.getNumber());
        ports.add(this.dynamicPort5.getNumber());
        ports.add(this.dynamicPort6.getNumber());
        greenMailSupport.startServers(ports);
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("jms://in6?connector=jmsConnectorNoRedelivery", (Object)MESSAGE_TO_SEND, null);
        endMessageProcessorExecuted.await(5000L, TimeUnit.MILLISECONDS);
        ((Lifecycle)this.getFlowConstruct("RollbackTransactionAndSendEmail")).stop();
        MuleMessage response = client.request("jms://in6?connector=jmsConnectorNoRedelivery", 5000L);
        Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)MESSAGE_TO_SEND));
        greenMailSupport.getServers().waitForIncomingEmail(10000L, 1);
        MimeMessage[] messages = greenMailSupport.getServers().getReceivedMessages();
        Assert.assertNotNull((String)"did not receive any messages", (Object)messages);
        Assert.assertEquals((String)"did not receive 1 mail", (long)1L, (long)messages.length);
    }

    public static class PreservePayloadExceptionStrategy
    extends AbstractMessagingExceptionStrategy {
        public PreservePayloadExceptionStrategy(MuleContext muleContext) {
            super(muleContext);
        }

        public MuleEvent handleException(Exception e, MuleEvent event) {
            Object payloadBeforeException = event.getMessage().getPayload();
            MuleEvent resultEvent = super.handleException(e, event);
            resultEvent.getMessage().setPayload(payloadBeforeException);
            return resultEvent;
        }
    }

    public static class EndMessageProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            endMessageProcessorExecuted.release();
            return event;
        }
    }
}

