/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.transaction.TransactionException;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transaction.TransactionCoordination;

public class ExceptionStrategyTransactionTestCase
extends AbstractServiceAndFlowTestCase {
    private static String failure;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/exceptions/exception-strategy-transaction-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/exceptions/exception-strategy-transaction-test-flow.xml"});
    }

    public ExceptionStrategyTransactionTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testRequestReply() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("InputQueueClient", (Object)"payload", null);
        Assert.assertNotNull((Object)client.request("ExceptionQueue", 10000L));
        if (failure != null) {
            Assert.fail((String)failure);
        }
    }

    @Test
    public void testNoInfiniteLoop() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("InputQueueClient2", (Object)"payload", null);
        Thread.sleep(500L);
        if (failure != null) {
            Assert.fail((String)failure);
        }
    }

    public static class AssertRollbackServiceExceptionStrategy
    extends DefaultMessagingExceptionStrategy {
        private int visits = 0;

        protected void routeException(MuleEvent event, Throwable t) {
            super.routeException(event, t);
            if (this.visits++ > 1) {
                failure = "Exception strategy should only be called once";
                Assert.fail((String)"Exception strategy should only be called once");
            }
            try {
                if (TransactionCoordination.getInstance().getTransaction() != null && !TransactionCoordination.getInstance().getTransaction().isRollbackOnly()) {
                    failure = "transaction should have been set for rollback";
                }
            }
            catch (TransactionException e) {
                failure = e.getMessage();
                Assert.fail((String)e.getMessage());
            }
        }
    }
}

